/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1IngressBackend;
import io.kubernetes.client.openapi.models.V1IngressRule;
import io.kubernetes.client.openapi.models.V1IngressTLS;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1IngressSpec {
    public static final String SERIALIZED_NAME_DEFAULT_BACKEND = "defaultBackend";
    @SerializedName(value="defaultBackend")
    private V1IngressBackend defaultBackend;
    public static final String SERIALIZED_NAME_INGRESS_CLASS_NAME = "ingressClassName";
    @SerializedName(value="ingressClassName")
    private String ingressClassName;
    public static final String SERIALIZED_NAME_RULES = "rules";
    @SerializedName(value="rules")
    private List<V1IngressRule> rules;
    public static final String SERIALIZED_NAME_TLS = "tls";
    @SerializedName(value="tls")
    private List<V1IngressTLS> tls;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1IngressSpec defaultBackend(V1IngressBackend defaultBackend) {
        this.defaultBackend = defaultBackend;
        return this;
    }

    @Nullable
    public V1IngressBackend getDefaultBackend() {
        return this.defaultBackend;
    }

    public void setDefaultBackend(V1IngressBackend defaultBackend) {
        this.defaultBackend = defaultBackend;
    }

    public V1IngressSpec ingressClassName(String ingressClassName) {
        this.ingressClassName = ingressClassName;
        return this;
    }

    @Nullable
    public String getIngressClassName() {
        return this.ingressClassName;
    }

    public void setIngressClassName(String ingressClassName) {
        this.ingressClassName = ingressClassName;
    }

    public V1IngressSpec rules(List<V1IngressRule> rules) {
        this.rules = rules;
        return this;
    }

    public V1IngressSpec addRulesItem(V1IngressRule rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1IngressRule>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    @Nullable
    public List<V1IngressRule> getRules() {
        return this.rules;
    }

    public void setRules(List<V1IngressRule> rules) {
        this.rules = rules;
    }

    public V1IngressSpec tls(List<V1IngressTLS> tls) {
        this.tls = tls;
        return this;
    }

    public V1IngressSpec addTlsItem(V1IngressTLS tlsItem) {
        if (this.tls == null) {
            this.tls = new ArrayList<V1IngressTLS>();
        }
        this.tls.add(tlsItem);
        return this;
    }

    @Nullable
    public List<V1IngressTLS> getTls() {
        return this.tls;
    }

    public void setTls(List<V1IngressTLS> tls) {
        this.tls = tls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1IngressSpec v1IngressSpec = (V1IngressSpec)o;
        return Objects.equals(this.defaultBackend, v1IngressSpec.defaultBackend) && Objects.equals(this.ingressClassName, v1IngressSpec.ingressClassName) && Objects.equals(this.rules, v1IngressSpec.rules) && Objects.equals(this.tls, v1IngressSpec.tls);
    }

    public int hashCode() {
        return Objects.hash(this.defaultBackend, this.ingressClassName, this.rules, this.tls);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1IngressSpec {\n");
        sb.append("    defaultBackend: ").append(this.toIndentedString(this.defaultBackend)).append("\n");
        sb.append("    ingressClassName: ").append(this.toIndentedString(this.ingressClassName)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("    tls: ").append(this.toIndentedString(this.tls)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraytls;
        JsonArray jsonArrayrules;
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1IngressSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1IngressSpec` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEFAULT_BACKEND) != null && !jsonObj.get(SERIALIZED_NAME_DEFAULT_BACKEND).isJsonNull()) {
            V1IngressBackend.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DEFAULT_BACKEND));
        }
        if (jsonObj.get(SERIALIZED_NAME_INGRESS_CLASS_NAME) != null && !jsonObj.get(SERIALIZED_NAME_INGRESS_CLASS_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INGRESS_CLASS_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ingressClassName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INGRESS_CLASS_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RULES) != null && !jsonObj.get(SERIALIZED_NAME_RULES).isJsonNull() && (jsonArrayrules = jsonObj.getAsJsonArray(SERIALIZED_NAME_RULES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RULES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `rules` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RULES).toString()));
            }
            for (int i = 0; i < jsonArrayrules.size(); ++i) {
                V1IngressRule.validateJsonObject(jsonArrayrules.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TLS) != null && !jsonObj.get(SERIALIZED_NAME_TLS).isJsonNull() && (jsonArraytls = jsonObj.getAsJsonArray(SERIALIZED_NAME_TLS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TLS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `tls` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TLS).toString()));
            }
            for (int i = 0; i < jsonArraytls.size(); ++i) {
                V1IngressTLS.validateJsonObject(jsonArraytls.get(i).getAsJsonObject());
            }
        }
    }

    public static V1IngressSpec fromJson(String jsonString) throws IOException {
        return (V1IngressSpec)JSON.getGson().fromJson(jsonString, V1IngressSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DEFAULT_BACKEND);
        openapiFields.add(SERIALIZED_NAME_INGRESS_CLASS_NAME);
        openapiFields.add(SERIALIZED_NAME_RULES);
        openapiFields.add(SERIALIZED_NAME_TLS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1IngressSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1IngressSpec.class));
            return new TypeAdapter<V1IngressSpec>(){

                public void write(JsonWriter out, V1IngressSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1IngressSpec read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1IngressSpec.validateJsonObject(jsonObj);
                    return (V1IngressSpec)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

