/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1CSIStorageCapacity
implements KubernetesObject {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_CAPACITY = "capacity";
    @SerializedName(value="capacity")
    private Quantity capacity;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_MAXIMUM_VOLUME_SIZE = "maximumVolumeSize";
    @SerializedName(value="maximumVolumeSize")
    private Quantity maximumVolumeSize;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_NODE_TOPOLOGY = "nodeTopology";
    @SerializedName(value="nodeTopology")
    private V1LabelSelector nodeTopology;
    public static final String SERIALIZED_NAME_STORAGE_CLASS_NAME = "storageClassName";
    @SerializedName(value="storageClassName")
    private String storageClassName;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1CSIStorageCapacity apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1CSIStorageCapacity capacity(Quantity capacity) {
        this.capacity = capacity;
        return this;
    }

    @Nullable
    public Quantity getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Quantity capacity) {
        this.capacity = capacity;
    }

    public V1CSIStorageCapacity kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1CSIStorageCapacity maximumVolumeSize(Quantity maximumVolumeSize) {
        this.maximumVolumeSize = maximumVolumeSize;
        return this;
    }

    @Nullable
    public Quantity getMaximumVolumeSize() {
        return this.maximumVolumeSize;
    }

    public void setMaximumVolumeSize(Quantity maximumVolumeSize) {
        this.maximumVolumeSize = maximumVolumeSize;
    }

    public V1CSIStorageCapacity metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1CSIStorageCapacity nodeTopology(V1LabelSelector nodeTopology) {
        this.nodeTopology = nodeTopology;
        return this;
    }

    @Nullable
    public V1LabelSelector getNodeTopology() {
        return this.nodeTopology;
    }

    public void setNodeTopology(V1LabelSelector nodeTopology) {
        this.nodeTopology = nodeTopology;
    }

    public V1CSIStorageCapacity storageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
        return this;
    }

    @Nonnull
    public String getStorageClassName() {
        return this.storageClassName;
    }

    public void setStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CSIStorageCapacity v1CSIStorageCapacity = (V1CSIStorageCapacity)o;
        return Objects.equals(this.apiVersion, v1CSIStorageCapacity.apiVersion) && Objects.equals(this.capacity, v1CSIStorageCapacity.capacity) && Objects.equals(this.kind, v1CSIStorageCapacity.kind) && Objects.equals(this.maximumVolumeSize, v1CSIStorageCapacity.maximumVolumeSize) && Objects.equals(this.metadata, v1CSIStorageCapacity.metadata) && Objects.equals(this.nodeTopology, v1CSIStorageCapacity.nodeTopology) && Objects.equals(this.storageClassName, v1CSIStorageCapacity.storageClassName);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.capacity, this.kind, this.maximumVolumeSize, this.metadata, this.nodeTopology, this.storageClassName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CSIStorageCapacity {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    maximumVolumeSize: ").append(this.toIndentedString(this.maximumVolumeSize)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    nodeTopology: ").append(this.toIndentedString(this.nodeTopology)).append("\n");
        sb.append("    storageClassName: ").append(this.toIndentedString(this.storageClassName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1CSIStorageCapacity is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1CSIStorageCapacity` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CAPACITY) != null && !jsonObj.get(SERIALIZED_NAME_CAPACITY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CAPACITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `capacity` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CAPACITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAXIMUM_VOLUME_SIZE) != null && !jsonObj.get(SERIALIZED_NAME_MAXIMUM_VOLUME_SIZE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MAXIMUM_VOLUME_SIZE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `maximumVolumeSize` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAXIMUM_VOLUME_SIZE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_METADATA) != null && !jsonObj.get(SERIALIZED_NAME_METADATA).isJsonNull()) {
            V1ObjectMeta.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_METADATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_NODE_TOPOLOGY) != null && !jsonObj.get(SERIALIZED_NAME_NODE_TOPOLOGY).isJsonNull()) {
            V1LabelSelector.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_NODE_TOPOLOGY));
        }
        if (!jsonObj.get(SERIALIZED_NAME_STORAGE_CLASS_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `storageClassName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORAGE_CLASS_NAME).toString()));
        }
    }

    public static V1CSIStorageCapacity fromJson(String jsonString) throws IOException {
        return (V1CSIStorageCapacity)JSON.getGson().fromJson(jsonString, V1CSIStorageCapacity.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_CAPACITY);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_MAXIMUM_VOLUME_SIZE);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_NODE_TOPOLOGY);
        openapiFields.add(SERIALIZED_NAME_STORAGE_CLASS_NAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_STORAGE_CLASS_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1CSIStorageCapacity.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1CSIStorageCapacity.class));
            return new TypeAdapter<V1CSIStorageCapacity>(){

                public void write(JsonWriter out, V1CSIStorageCapacity value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1CSIStorageCapacity read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1CSIStorageCapacity.validateJsonObject(jsonObj);
                    return (V1CSIStorageCapacity)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

