/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluentImpl;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaim;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimBuilder;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimFluentImpl;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.kubernetes.client.openapi.models.V1PodTemplateSpecBuilder;
import io.kubernetes.client.openapi.models.V1PodTemplateSpecFluentImpl;
import io.kubernetes.client.openapi.models.V1StatefulSetPersistentVolumeClaimRetentionPolicy;
import io.kubernetes.client.openapi.models.V1StatefulSetPersistentVolumeClaimRetentionPolicyBuilder;
import io.kubernetes.client.openapi.models.V1StatefulSetPersistentVolumeClaimRetentionPolicyFluentImpl;
import io.kubernetes.client.openapi.models.V1StatefulSetSpec;
import io.kubernetes.client.openapi.models.V1StatefulSetSpecFluent;
import io.kubernetes.client.openapi.models.V1StatefulSetUpdateStrategy;
import io.kubernetes.client.openapi.models.V1StatefulSetUpdateStrategyBuilder;
import io.kubernetes.client.openapi.models.V1StatefulSetUpdateStrategyFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1StatefulSetSpecFluentImpl<A extends V1StatefulSetSpecFluent<A>>
extends BaseFluent<A>
implements V1StatefulSetSpecFluent<A> {
    private Integer minReadySeconds;
    private V1StatefulSetPersistentVolumeClaimRetentionPolicyBuilder persistentVolumeClaimRetentionPolicy;
    private String podManagementPolicy;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private V1LabelSelectorBuilder selector;
    private String serviceName;
    private V1PodTemplateSpecBuilder template;
    private V1StatefulSetUpdateStrategyBuilder updateStrategy;
    private ArrayList<V1PersistentVolumeClaimBuilder> volumeClaimTemplates;

    public V1StatefulSetSpecFluentImpl() {
    }

    public V1StatefulSetSpecFluentImpl(V1StatefulSetSpec instance) {
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withPersistentVolumeClaimRetentionPolicy(instance.getPersistentVolumeClaimRetentionPolicy());
        this.withPodManagementPolicy(instance.getPodManagementPolicy());
        this.withReplicas(instance.getReplicas());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withSelector(instance.getSelector());
        this.withServiceName(instance.getServiceName());
        this.withTemplate(instance.getTemplate());
        this.withUpdateStrategy(instance.getUpdateStrategy());
        this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());
    }

    @Override
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    @Override
    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    @Override
    public Boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    @Override
    @Deprecated
    public V1StatefulSetPersistentVolumeClaimRetentionPolicy getPersistentVolumeClaimRetentionPolicy() {
        return this.persistentVolumeClaimRetentionPolicy != null ? this.persistentVolumeClaimRetentionPolicy.build() : null;
    }

    @Override
    public V1StatefulSetPersistentVolumeClaimRetentionPolicy buildPersistentVolumeClaimRetentionPolicy() {
        return this.persistentVolumeClaimRetentionPolicy != null ? this.persistentVolumeClaimRetentionPolicy.build() : null;
    }

    @Override
    public A withPersistentVolumeClaimRetentionPolicy(V1StatefulSetPersistentVolumeClaimRetentionPolicy persistentVolumeClaimRetentionPolicy) {
        this._visitables.get("persistentVolumeClaimRetentionPolicy").remove(this.persistentVolumeClaimRetentionPolicy);
        if (persistentVolumeClaimRetentionPolicy != null) {
            this.persistentVolumeClaimRetentionPolicy = new V1StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(persistentVolumeClaimRetentionPolicy);
            this._visitables.get("persistentVolumeClaimRetentionPolicy").add(this.persistentVolumeClaimRetentionPolicy);
        } else {
            this.persistentVolumeClaimRetentionPolicy = null;
            this._visitables.get("persistentVolumeClaimRetentionPolicy").remove(this.persistentVolumeClaimRetentionPolicy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPersistentVolumeClaimRetentionPolicy() {
        return this.persistentVolumeClaimRetentionPolicy != null;
    }

    @Override
    public V1StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<A> withNewPersistentVolumeClaimRetentionPolicy() {
        return new PersistentVolumeClaimRetentionPolicyNestedImpl();
    }

    @Override
    public V1StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<A> withNewPersistentVolumeClaimRetentionPolicyLike(V1StatefulSetPersistentVolumeClaimRetentionPolicy item) {
        return new PersistentVolumeClaimRetentionPolicyNestedImpl(item);
    }

    @Override
    public V1StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<A> editPersistentVolumeClaimRetentionPolicy() {
        return this.withNewPersistentVolumeClaimRetentionPolicyLike(this.getPersistentVolumeClaimRetentionPolicy());
    }

    @Override
    public V1StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<A> editOrNewPersistentVolumeClaimRetentionPolicy() {
        return this.withNewPersistentVolumeClaimRetentionPolicyLike(this.getPersistentVolumeClaimRetentionPolicy() != null ? this.getPersistentVolumeClaimRetentionPolicy() : new V1StatefulSetPersistentVolumeClaimRetentionPolicyBuilder().build());
    }

    @Override
    public V1StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<A> editOrNewPersistentVolumeClaimRetentionPolicyLike(V1StatefulSetPersistentVolumeClaimRetentionPolicy item) {
        return this.withNewPersistentVolumeClaimRetentionPolicyLike(this.getPersistentVolumeClaimRetentionPolicy() != null ? this.getPersistentVolumeClaimRetentionPolicy() : item);
    }

    @Override
    public String getPodManagementPolicy() {
        return this.podManagementPolicy;
    }

    @Override
    public A withPodManagementPolicy(String podManagementPolicy) {
        this.podManagementPolicy = podManagementPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasPodManagementPolicy() {
        return this.podManagementPolicy != null;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    @Override
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasRevisionHistoryLimit() {
        return this.revisionHistoryLimit != null;
    }

    @Override
    @Deprecated
    public V1LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public V1LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(V1LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new V1LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get("selector").remove(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public V1StatefulSetSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public V1StatefulSetSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public V1StatefulSetSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public V1StatefulSetSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new V1LabelSelectorBuilder().build());
    }

    @Override
    public V1StatefulSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public A withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return (A)this;
    }

    @Override
    public Boolean hasServiceName() {
        return this.serviceName != null;
    }

    @Override
    @Deprecated
    public V1PodTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public V1PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(V1PodTemplateSpec template) {
        this._visitables.get("template").remove(this.template);
        if (template != null) {
            this.template = new V1PodTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get("template").remove(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public V1StatefulSetSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public V1StatefulSetSpecFluent.TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public V1StatefulSetSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public V1StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new V1PodTemplateSpecBuilder().build());
    }

    @Override
    public V1StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    @Override
    @Deprecated
    public V1StatefulSetUpdateStrategy getUpdateStrategy() {
        return this.updateStrategy != null ? this.updateStrategy.build() : null;
    }

    @Override
    public V1StatefulSetUpdateStrategy buildUpdateStrategy() {
        return this.updateStrategy != null ? this.updateStrategy.build() : null;
    }

    @Override
    public A withUpdateStrategy(V1StatefulSetUpdateStrategy updateStrategy) {
        this._visitables.get("updateStrategy").remove(this.updateStrategy);
        if (updateStrategy != null) {
            this.updateStrategy = new V1StatefulSetUpdateStrategyBuilder(updateStrategy);
            this._visitables.get("updateStrategy").add(this.updateStrategy);
        } else {
            this.updateStrategy = null;
            this._visitables.get("updateStrategy").remove(this.updateStrategy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUpdateStrategy() {
        return this.updateStrategy != null;
    }

    @Override
    public V1StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy() {
        return new UpdateStrategyNestedImpl();
    }

    @Override
    public V1StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(V1StatefulSetUpdateStrategy item) {
        return new UpdateStrategyNestedImpl(item);
    }

    @Override
    public V1StatefulSetSpecFluent.UpdateStrategyNested<A> editUpdateStrategy() {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy());
    }

    @Override
    public V1StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy() {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy() != null ? this.getUpdateStrategy() : new V1StatefulSetUpdateStrategyBuilder().build());
    }

    @Override
    public V1StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(V1StatefulSetUpdateStrategy item) {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy() != null ? this.getUpdateStrategy() : item);
    }

    @Override
    public A addToVolumeClaimTemplates(Integer index, V1PersistentVolumeClaim item) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList();
        }
        V1PersistentVolumeClaimBuilder builder = new V1PersistentVolumeClaimBuilder(item);
        this._visitables.get("volumeClaimTemplates").add(index >= 0 ? index.intValue() : this._visitables.get("volumeClaimTemplates").size(), builder);
        this.volumeClaimTemplates.add(index >= 0 ? index.intValue() : this.volumeClaimTemplates.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumeClaimTemplates(Integer index, V1PersistentVolumeClaim item) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList();
        }
        V1PersistentVolumeClaimBuilder builder = new V1PersistentVolumeClaimBuilder(item);
        if (index < 0 || index >= this._visitables.get("volumeClaimTemplates").size()) {
            this._visitables.get("volumeClaimTemplates").add(builder);
        } else {
            this._visitables.get("volumeClaimTemplates").set(index, builder);
        }
        if (index < 0 || index >= this.volumeClaimTemplates.size()) {
            this.volumeClaimTemplates.add(builder);
        } else {
            this.volumeClaimTemplates.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumeClaimTemplates(V1PersistentVolumeClaim ... items) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList();
        }
        for (V1PersistentVolumeClaim item : items) {
            V1PersistentVolumeClaimBuilder builder = new V1PersistentVolumeClaimBuilder(item);
            this._visitables.get("volumeClaimTemplates").add(builder);
            this.volumeClaimTemplates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumeClaimTemplates(Collection<V1PersistentVolumeClaim> items) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList();
        }
        for (V1PersistentVolumeClaim item : items) {
            V1PersistentVolumeClaimBuilder builder = new V1PersistentVolumeClaimBuilder(item);
            this._visitables.get("volumeClaimTemplates").add(builder);
            this.volumeClaimTemplates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeClaimTemplates(V1PersistentVolumeClaim ... items) {
        for (V1PersistentVolumeClaim item : items) {
            V1PersistentVolumeClaimBuilder builder = new V1PersistentVolumeClaimBuilder(item);
            this._visitables.get("volumeClaimTemplates").remove(builder);
            if (this.volumeClaimTemplates == null) continue;
            this.volumeClaimTemplates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumeClaimTemplates(Collection<V1PersistentVolumeClaim> items) {
        for (V1PersistentVolumeClaim item : items) {
            V1PersistentVolumeClaimBuilder builder = new V1PersistentVolumeClaimBuilder(item);
            this._visitables.get("volumeClaimTemplates").remove(builder);
            if (this.volumeClaimTemplates == null) continue;
            this.volumeClaimTemplates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVolumeClaimTemplates(Predicate<V1PersistentVolumeClaimBuilder> predicate) {
        if (this.volumeClaimTemplates == null) {
            return (A)this;
        }
        Iterator<V1PersistentVolumeClaimBuilder> each = this.volumeClaimTemplates.iterator();
        Object visitables = this._visitables.get("volumeClaimTemplates");
        while (each.hasNext()) {
            V1PersistentVolumeClaimBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1PersistentVolumeClaim> getVolumeClaimTemplates() {
        return this.volumeClaimTemplates != null ? V1StatefulSetSpecFluentImpl.build(this.volumeClaimTemplates) : null;
    }

    @Override
    public List<V1PersistentVolumeClaim> buildVolumeClaimTemplates() {
        return this.volumeClaimTemplates != null ? V1StatefulSetSpecFluentImpl.build(this.volumeClaimTemplates) : null;
    }

    @Override
    public V1PersistentVolumeClaim buildVolumeClaimTemplate(Integer index) {
        return this.volumeClaimTemplates.get(index).build();
    }

    @Override
    public V1PersistentVolumeClaim buildFirstVolumeClaimTemplate() {
        return this.volumeClaimTemplates.get(0).build();
    }

    @Override
    public V1PersistentVolumeClaim buildLastVolumeClaimTemplate() {
        return this.volumeClaimTemplates.get(this.volumeClaimTemplates.size() - 1).build();
    }

    @Override
    public V1PersistentVolumeClaim buildMatchingVolumeClaimTemplate(Predicate<V1PersistentVolumeClaimBuilder> predicate) {
        for (V1PersistentVolumeClaimBuilder item : this.volumeClaimTemplates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolumeClaimTemplate(Predicate<V1PersistentVolumeClaimBuilder> predicate) {
        for (V1PersistentVolumeClaimBuilder item : this.volumeClaimTemplates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumeClaimTemplates(List<V1PersistentVolumeClaim> volumeClaimTemplates) {
        if (this.volumeClaimTemplates != null) {
            this._visitables.get("volumeClaimTemplates").removeAll(this.volumeClaimTemplates);
        }
        if (volumeClaimTemplates != null) {
            this.volumeClaimTemplates = new ArrayList();
            for (V1PersistentVolumeClaim item : volumeClaimTemplates) {
                this.addToVolumeClaimTemplates(item);
            }
        } else {
            this.volumeClaimTemplates = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumeClaimTemplates(V1PersistentVolumeClaim ... volumeClaimTemplates) {
        if (this.volumeClaimTemplates != null) {
            this.volumeClaimTemplates.clear();
        }
        if (volumeClaimTemplates != null) {
            for (V1PersistentVolumeClaim item : volumeClaimTemplates) {
                this.addToVolumeClaimTemplates(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeClaimTemplates() {
        return this.volumeClaimTemplates != null && !this.volumeClaimTemplates.isEmpty();
    }

    @Override
    public V1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplate() {
        return new VolumeClaimTemplatesNestedImpl();
    }

    @Override
    public V1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplateLike(V1PersistentVolumeClaim item) {
        return new VolumeClaimTemplatesNestedImpl(-1, item);
    }

    @Override
    public V1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> setNewVolumeClaimTemplateLike(Integer index, V1PersistentVolumeClaim item) {
        return new VolumeClaimTemplatesNestedImpl(index, item);
    }

    @Override
    public V1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editVolumeClaimTemplate(Integer index) {
        if (this.volumeClaimTemplates.size() <= index) {
            throw new RuntimeException("Can't edit volumeClaimTemplates. Index exceeds size.");
        }
        return this.setNewVolumeClaimTemplateLike(index, this.buildVolumeClaimTemplate(index));
    }

    @Override
    public V1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editFirstVolumeClaimTemplate() {
        if (this.volumeClaimTemplates.size() == 0) {
            throw new RuntimeException("Can't edit first volumeClaimTemplates. The list is empty.");
        }
        return this.setNewVolumeClaimTemplateLike(0, this.buildVolumeClaimTemplate(0));
    }

    @Override
    public V1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editLastVolumeClaimTemplate() {
        int index = this.volumeClaimTemplates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeClaimTemplates. The list is empty.");
        }
        return this.setNewVolumeClaimTemplateLike(index, this.buildVolumeClaimTemplate(index));
    }

    @Override
    public V1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editMatchingVolumeClaimTemplate(Predicate<V1PersistentVolumeClaimBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeClaimTemplates.size(); ++i) {
            if (!predicate.test(this.volumeClaimTemplates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeClaimTemplates. No match found.");
        }
        return this.setNewVolumeClaimTemplateLike(index, this.buildVolumeClaimTemplate(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1StatefulSetSpecFluentImpl that = (V1StatefulSetSpecFluentImpl)o;
        if (this.minReadySeconds != null ? !this.minReadySeconds.equals(that.minReadySeconds) : that.minReadySeconds != null) {
            return false;
        }
        if (this.persistentVolumeClaimRetentionPolicy != null ? !this.persistentVolumeClaimRetentionPolicy.equals(that.persistentVolumeClaimRetentionPolicy) : that.persistentVolumeClaimRetentionPolicy != null) {
            return false;
        }
        if (this.podManagementPolicy != null ? !this.podManagementPolicy.equals(that.podManagementPolicy) : that.podManagementPolicy != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.revisionHistoryLimit != null ? !this.revisionHistoryLimit.equals(that.revisionHistoryLimit) : that.revisionHistoryLimit != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        if (this.updateStrategy != null ? !this.updateStrategy.equals(that.updateStrategy) : that.updateStrategy != null) {
            return false;
        }
        return !(this.volumeClaimTemplates != null ? !this.volumeClaimTemplates.equals(that.volumeClaimTemplates) : that.volumeClaimTemplates != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.persistentVolumeClaimRetentionPolicy, this.podManagementPolicy, this.replicas, this.revisionHistoryLimit, this.selector, this.serviceName, this.template, this.updateStrategy, this.volumeClaimTemplates, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.minReadySeconds != null) {
            sb.append("minReadySeconds:");
            sb.append(this.minReadySeconds + ",");
        }
        if (this.persistentVolumeClaimRetentionPolicy != null) {
            sb.append("persistentVolumeClaimRetentionPolicy:");
            sb.append(this.persistentVolumeClaimRetentionPolicy + ",");
        }
        if (this.podManagementPolicy != null) {
            sb.append("podManagementPolicy:");
            sb.append(this.podManagementPolicy + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.revisionHistoryLimit != null) {
            sb.append("revisionHistoryLimit:");
            sb.append(this.revisionHistoryLimit + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.serviceName != null) {
            sb.append("serviceName:");
            sb.append(this.serviceName + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.updateStrategy != null) {
            sb.append("updateStrategy:");
            sb.append(this.updateStrategy + ",");
        }
        if (this.volumeClaimTemplates != null && !this.volumeClaimTemplates.isEmpty()) {
            sb.append("volumeClaimTemplates:");
            sb.append(this.volumeClaimTemplates);
        }
        sb.append("}");
        return sb.toString();
    }

    class PersistentVolumeClaimRetentionPolicyNestedImpl<N>
    extends V1StatefulSetPersistentVolumeClaimRetentionPolicyFluentImpl<V1StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<N>>
    implements V1StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<N>,
    Nested<N> {
        V1StatefulSetPersistentVolumeClaimRetentionPolicyBuilder builder;

        PersistentVolumeClaimRetentionPolicyNestedImpl(V1StatefulSetPersistentVolumeClaimRetentionPolicy item) {
            this.builder = new V1StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(this, item);
        }

        PersistentVolumeClaimRetentionPolicyNestedImpl() {
            this.builder = new V1StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1StatefulSetSpecFluentImpl.this.withPersistentVolumeClaimRetentionPolicy(this.builder.build());
        }

        @Override
        public N endPersistentVolumeClaimRetentionPolicy() {
            return this.and();
        }
    }

    class SelectorNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V1StatefulSetSpecFluent.SelectorNested<N>>
    implements V1StatefulSetSpecFluent.SelectorNested<N>,
    Nested<N> {
        V1LabelSelectorBuilder builder;

        SelectorNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1StatefulSetSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }

    class TemplateNestedImpl<N>
    extends V1PodTemplateSpecFluentImpl<V1StatefulSetSpecFluent.TemplateNested<N>>
    implements V1StatefulSetSpecFluent.TemplateNested<N>,
    Nested<N> {
        V1PodTemplateSpecBuilder builder;

        TemplateNestedImpl(V1PodTemplateSpec item) {
            this.builder = new V1PodTemplateSpecBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new V1PodTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1StatefulSetSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    class UpdateStrategyNestedImpl<N>
    extends V1StatefulSetUpdateStrategyFluentImpl<V1StatefulSetSpecFluent.UpdateStrategyNested<N>>
    implements V1StatefulSetSpecFluent.UpdateStrategyNested<N>,
    Nested<N> {
        V1StatefulSetUpdateStrategyBuilder builder;

        UpdateStrategyNestedImpl(V1StatefulSetUpdateStrategy item) {
            this.builder = new V1StatefulSetUpdateStrategyBuilder(this, item);
        }

        UpdateStrategyNestedImpl() {
            this.builder = new V1StatefulSetUpdateStrategyBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1StatefulSetSpecFluentImpl.this.withUpdateStrategy(this.builder.build());
        }

        @Override
        public N endUpdateStrategy() {
            return this.and();
        }
    }

    class VolumeClaimTemplatesNestedImpl<N>
    extends V1PersistentVolumeClaimFluentImpl<V1StatefulSetSpecFluent.VolumeClaimTemplatesNested<N>>
    implements V1StatefulSetSpecFluent.VolumeClaimTemplatesNested<N>,
    Nested<N> {
        V1PersistentVolumeClaimBuilder builder;
        Integer index;

        VolumeClaimTemplatesNestedImpl(Integer index, V1PersistentVolumeClaim item) {
            this.index = index;
            this.builder = new V1PersistentVolumeClaimBuilder(this, item);
        }

        VolumeClaimTemplatesNestedImpl() {
            this.index = -1;
            this.builder = new V1PersistentVolumeClaimBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1StatefulSetSpecFluentImpl.this.setToVolumeClaimTemplates(this.index, this.builder.build());
        }

        @Override
        public N endVolumeClaimTemplate() {
            return this.and();
        }
    }
}

