/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1DeleteOptionsBuilder;
import io.kubernetes.client.openapi.models.V1DeleteOptionsFluentImpl;
import io.kubernetes.client.openapi.models.V1Eviction;
import io.kubernetes.client.openapi.models.V1EvictionFluent;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluentImpl;
import java.util.Objects;

public class V1EvictionFluentImpl<A extends V1EvictionFluent<A>>
extends BaseFluent<A>
implements V1EvictionFluent<A> {
    private String apiVersion;
    private V1DeleteOptionsBuilder deleteOptions;
    private String kind;
    private V1ObjectMetaBuilder metadata;

    public V1EvictionFluentImpl() {
    }

    public V1EvictionFluentImpl(V1Eviction instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withDeleteOptions(instance.getDeleteOptions());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public V1DeleteOptions getDeleteOptions() {
        return this.deleteOptions != null ? this.deleteOptions.build() : null;
    }

    @Override
    public V1DeleteOptions buildDeleteOptions() {
        return this.deleteOptions != null ? this.deleteOptions.build() : null;
    }

    @Override
    public A withDeleteOptions(V1DeleteOptions deleteOptions) {
        this._visitables.get("deleteOptions").remove(this.deleteOptions);
        if (deleteOptions != null) {
            this.deleteOptions = new V1DeleteOptionsBuilder(deleteOptions);
            this._visitables.get("deleteOptions").add(this.deleteOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDeleteOptions() {
        return this.deleteOptions != null;
    }

    @Override
    public V1EvictionFluent.DeleteOptionsNested<A> withNewDeleteOptions() {
        return new DeleteOptionsNestedImpl();
    }

    @Override
    public V1EvictionFluent.DeleteOptionsNested<A> withNewDeleteOptionsLike(V1DeleteOptions item) {
        return new DeleteOptionsNestedImpl(item);
    }

    @Override
    public V1EvictionFluent.DeleteOptionsNested<A> editDeleteOptions() {
        return this.withNewDeleteOptionsLike(this.getDeleteOptions());
    }

    @Override
    public V1EvictionFluent.DeleteOptionsNested<A> editOrNewDeleteOptions() {
        return this.withNewDeleteOptionsLike(this.getDeleteOptions() != null ? this.getDeleteOptions() : new V1DeleteOptionsBuilder().build());
    }

    @Override
    public V1EvictionFluent.DeleteOptionsNested<A> editOrNewDeleteOptionsLike(V1DeleteOptions item) {
        return this.withNewDeleteOptionsLike(this.getDeleteOptions() != null ? this.getDeleteOptions() : item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1EvictionFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1EvictionFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1EvictionFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1EvictionFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1EvictionFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1EvictionFluentImpl that = (V1EvictionFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.deleteOptions != null ? !this.deleteOptions.equals(that.deleteOptions) : that.deleteOptions != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.deleteOptions, this.kind, this.metadata, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.deleteOptions != null) {
            sb.append("deleteOptions:");
            sb.append(this.deleteOptions + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
        }
        sb.append("}");
        return sb.toString();
    }

    class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1EvictionFluent.MetadataNested<N>>
    implements V1EvictionFluent.MetadataNested<N>,
    Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1EvictionFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    class DeleteOptionsNestedImpl<N>
    extends V1DeleteOptionsFluentImpl<V1EvictionFluent.DeleteOptionsNested<N>>
    implements V1EvictionFluent.DeleteOptionsNested<N>,
    Nested<N> {
        V1DeleteOptionsBuilder builder;

        DeleteOptionsNestedImpl(V1DeleteOptions item) {
            this.builder = new V1DeleteOptionsBuilder(this, item);
        }

        DeleteOptionsNestedImpl() {
            this.builder = new V1DeleteOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1EvictionFluentImpl.this.withDeleteOptions(this.builder.build());
        }

        @Override
        public N endDeleteOptions() {
            return this.and();
        }
    }
}

