/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1EndpointAddress;
import io.kubernetes.client.openapi.models.V1EndpointAddressFluent;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import io.kubernetes.client.openapi.models.V1ObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1ObjectReferenceFluentImpl;
import java.util.Objects;

public class V1EndpointAddressFluentImpl<A extends V1EndpointAddressFluent<A>>
extends BaseFluent<A>
implements V1EndpointAddressFluent<A> {
    private String hostname;
    private String ip;
    private String nodeName;
    private V1ObjectReferenceBuilder targetRef;

    public V1EndpointAddressFluentImpl() {
    }

    public V1EndpointAddressFluentImpl(V1EndpointAddress instance) {
        this.withHostname(instance.getHostname());
        this.withIp(instance.getIp());
        this.withNodeName(instance.getNodeName());
        this.withTargetRef(instance.getTargetRef());
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public A withIp(String ip) {
        this.ip = ip;
        return (A)this;
    }

    @Override
    public Boolean hasIp() {
        return this.ip != null;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    @Override
    public Boolean hasNodeName() {
        return this.nodeName != null;
    }

    @Override
    @Deprecated
    public V1ObjectReference getTargetRef() {
        return this.targetRef != null ? this.targetRef.build() : null;
    }

    @Override
    public V1ObjectReference buildTargetRef() {
        return this.targetRef != null ? this.targetRef.build() : null;
    }

    @Override
    public A withTargetRef(V1ObjectReference targetRef) {
        this._visitables.get("targetRef").remove(this.targetRef);
        if (targetRef != null) {
            this.targetRef = new V1ObjectReferenceBuilder(targetRef);
            this._visitables.get("targetRef").add(this.targetRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargetRef() {
        return this.targetRef != null;
    }

    @Override
    public V1EndpointAddressFluent.TargetRefNested<A> withNewTargetRef() {
        return new TargetRefNestedImpl();
    }

    @Override
    public V1EndpointAddressFluent.TargetRefNested<A> withNewTargetRefLike(V1ObjectReference item) {
        return new TargetRefNestedImpl(item);
    }

    @Override
    public V1EndpointAddressFluent.TargetRefNested<A> editTargetRef() {
        return this.withNewTargetRefLike(this.getTargetRef());
    }

    @Override
    public V1EndpointAddressFluent.TargetRefNested<A> editOrNewTargetRef() {
        return this.withNewTargetRefLike(this.getTargetRef() != null ? this.getTargetRef() : new V1ObjectReferenceBuilder().build());
    }

    @Override
    public V1EndpointAddressFluent.TargetRefNested<A> editOrNewTargetRefLike(V1ObjectReference item) {
        return this.withNewTargetRefLike(this.getTargetRef() != null ? this.getTargetRef() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1EndpointAddressFluentImpl that = (V1EndpointAddressFluentImpl)o;
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.ip != null ? !this.ip.equals(that.ip) : that.ip != null) {
            return false;
        }
        if (this.nodeName != null ? !this.nodeName.equals(that.nodeName) : that.nodeName != null) {
            return false;
        }
        return !(this.targetRef != null ? !this.targetRef.equals(that.targetRef) : that.targetRef != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hostname, this.ip, this.nodeName, this.targetRef, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.ip != null) {
            sb.append("ip:");
            sb.append(this.ip + ",");
        }
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName + ",");
        }
        if (this.targetRef != null) {
            sb.append("targetRef:");
            sb.append(this.targetRef);
        }
        sb.append("}");
        return sb.toString();
    }

    class TargetRefNestedImpl<N>
    extends V1ObjectReferenceFluentImpl<V1EndpointAddressFluent.TargetRefNested<N>>
    implements V1EndpointAddressFluent.TargetRefNested<N>,
    Nested<N> {
        V1ObjectReferenceBuilder builder;

        TargetRefNestedImpl(V1ObjectReference item) {
            this.builder = new V1ObjectReferenceBuilder(this, item);
        }

        TargetRefNestedImpl() {
            this.builder = new V1ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1EndpointAddressFluentImpl.this.withTargetRef(this.builder.build());
        }

        @Override
        public N endTargetRef() {
            return this.and();
        }
    }
}

