/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1EndpointConditions;
import io.kubernetes.client.openapi.models.V1EndpointHints;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Endpoint represents a single logical \"backend\" implementing a service.")
public class V1Endpoint {
    public static final String SERIALIZED_NAME_ADDRESSES = "addresses";
    @SerializedName(value="addresses")
    private List<String> addresses = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private V1EndpointConditions conditions;
    public static final String SERIALIZED_NAME_DEPRECATED_TOPOLOGY = "deprecatedTopology";
    @SerializedName(value="deprecatedTopology")
    private Map<String, String> deprecatedTopology = null;
    public static final String SERIALIZED_NAME_HINTS = "hints";
    @SerializedName(value="hints")
    private V1EndpointHints hints;
    public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
    @SerializedName(value="hostname")
    private String hostname;
    public static final String SERIALIZED_NAME_NODE_NAME = "nodeName";
    @SerializedName(value="nodeName")
    private String nodeName;
    public static final String SERIALIZED_NAME_TARGET_REF = "targetRef";
    @SerializedName(value="targetRef")
    private V1ObjectReference targetRef;
    public static final String SERIALIZED_NAME_ZONE = "zone";
    @SerializedName(value="zone")
    private String zone;

    public V1Endpoint addresses(List<String> addresses) {
        this.addresses = addresses;
        return this;
    }

    public V1Endpoint addAddressesItem(String addressesItem) {
        this.addresses.add(addressesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="addresses of this endpoint. The contents of this field are interpreted according to the corresponding EndpointSlice addressType field. Consumers must handle different types of addresses in the context of their own capabilities. This must contain at least one address but no more than 100.")
    public List<String> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    public V1Endpoint conditions(V1EndpointConditions conditions) {
        this.conditions = conditions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1EndpointConditions getConditions() {
        return this.conditions;
    }

    public void setConditions(V1EndpointConditions conditions) {
        this.conditions = conditions;
    }

    public V1Endpoint deprecatedTopology(Map<String, String> deprecatedTopology) {
        this.deprecatedTopology = deprecatedTopology;
        return this;
    }

    public V1Endpoint putDeprecatedTopologyItem(String key, String deprecatedTopologyItem) {
        if (this.deprecatedTopology == null) {
            this.deprecatedTopology = new HashMap<String, String>();
        }
        this.deprecatedTopology.put(key, deprecatedTopologyItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="deprecatedTopology contains topology information part of the v1beta1 API. This field is deprecated, and will be removed when the v1beta1 API is removed (no sooner than kubernetes v1.24).  While this field can hold values, it is not writable through the v1 API, and any attempts to write to it will be silently ignored. Topology information can be found in the zone and nodeName fields instead.")
    public Map<String, String> getDeprecatedTopology() {
        return this.deprecatedTopology;
    }

    public void setDeprecatedTopology(Map<String, String> deprecatedTopology) {
        this.deprecatedTopology = deprecatedTopology;
    }

    public V1Endpoint hints(V1EndpointHints hints) {
        this.hints = hints;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1EndpointHints getHints() {
        return this.hints;
    }

    public void setHints(V1EndpointHints hints) {
        this.hints = hints;
    }

    public V1Endpoint hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="hostname of this endpoint. This field may be used by consumers of endpoints to distinguish endpoints from each other (e.g. in DNS names). Multiple endpoints which use the same hostname should be considered fungible (e.g. multiple A values in DNS). Must be lowercase and pass DNS Label (RFC 1123) validation.")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public V1Endpoint nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="nodeName represents the name of the Node hosting this endpoint. This can be used to determine endpoints local to a Node. This field can be enabled with the EndpointSliceNodeName feature gate.")
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public V1Endpoint targetRef(V1ObjectReference targetRef) {
        this.targetRef = targetRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectReference getTargetRef() {
        return this.targetRef;
    }

    public void setTargetRef(V1ObjectReference targetRef) {
        this.targetRef = targetRef;
    }

    public V1Endpoint zone(String zone) {
        this.zone = zone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="zone is the name of the Zone this endpoint exists in.")
    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Endpoint v1Endpoint = (V1Endpoint)o;
        return Objects.equals(this.addresses, v1Endpoint.addresses) && Objects.equals(this.conditions, v1Endpoint.conditions) && Objects.equals(this.deprecatedTopology, v1Endpoint.deprecatedTopology) && Objects.equals(this.hints, v1Endpoint.hints) && Objects.equals(this.hostname, v1Endpoint.hostname) && Objects.equals(this.nodeName, v1Endpoint.nodeName) && Objects.equals(this.targetRef, v1Endpoint.targetRef) && Objects.equals(this.zone, v1Endpoint.zone);
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.conditions, this.deprecatedTopology, this.hints, this.hostname, this.nodeName, this.targetRef, this.zone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Endpoint {\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    deprecatedTopology: ").append(this.toIndentedString(this.deprecatedTopology)).append("\n");
        sb.append("    hints: ").append(this.toIndentedString(this.hints)).append("\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    nodeName: ").append(this.toIndentedString(this.nodeName)).append("\n");
        sb.append("    targetRef: ").append(this.toIndentedString(this.targetRef)).append("\n");
        sb.append("    zone: ").append(this.toIndentedString(this.zone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

