/*
Copyright 2022 The Kubernetes Authors.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;

/** Generated */
public interface V1EndpointSliceFluent<A extends V1EndpointSliceFluent<A>> extends Fluent<A> {
  public String getAddressType();

  public A withAddressType(java.lang.String addressType);

  public Boolean hasAddressType();

  public java.lang.String getApiVersion();

  public A withApiVersion(java.lang.String apiVersion);

  public java.lang.Boolean hasApiVersion();

  public A addToEndpoints(Integer index, io.kubernetes.client.openapi.models.V1Endpoint item);

  public A setToEndpoints(
      java.lang.Integer index, io.kubernetes.client.openapi.models.V1Endpoint item);

  public A addToEndpoints(io.kubernetes.client.openapi.models.V1Endpoint... items);

  public A addAllToEndpoints(Collection<io.kubernetes.client.openapi.models.V1Endpoint> items);

  public A removeFromEndpoints(io.kubernetes.client.openapi.models.V1Endpoint... items);

  public A removeAllFromEndpoints(
      java.util.Collection<io.kubernetes.client.openapi.models.V1Endpoint> items);

  public A removeMatchingFromEndpoints(Predicate<V1EndpointBuilder> predicate);

  /**
   * This method has been deprecated, please use method buildEndpoints instead.
   *
   * @return The buildable object.
   */
  @Deprecated
  public List<io.kubernetes.client.openapi.models.V1Endpoint> getEndpoints();

  public java.util.List<io.kubernetes.client.openapi.models.V1Endpoint> buildEndpoints();

  public io.kubernetes.client.openapi.models.V1Endpoint buildEndpoint(java.lang.Integer index);

  public io.kubernetes.client.openapi.models.V1Endpoint buildFirstEndpoint();

  public io.kubernetes.client.openapi.models.V1Endpoint buildLastEndpoint();

  public io.kubernetes.client.openapi.models.V1Endpoint buildMatchingEndpoint(
      java.util.function.Predicate<io.kubernetes.client.openapi.models.V1EndpointBuilder>
          predicate);

  public java.lang.Boolean hasMatchingEndpoint(
      java.util.function.Predicate<io.kubernetes.client.openapi.models.V1EndpointBuilder>
          predicate);

  public A withEndpoints(java.util.List<io.kubernetes.client.openapi.models.V1Endpoint> endpoints);

  public A withEndpoints(io.kubernetes.client.openapi.models.V1Endpoint... endpoints);

  public java.lang.Boolean hasEndpoints();

  public V1EndpointSliceFluent.EndpointsNested<A> addNewEndpoint();

  public V1EndpointSliceFluent.EndpointsNested<A> addNewEndpointLike(
      io.kubernetes.client.openapi.models.V1Endpoint item);

  public io.kubernetes.client.openapi.models.V1EndpointSliceFluent.EndpointsNested<A>
      setNewEndpointLike(
          java.lang.Integer index, io.kubernetes.client.openapi.models.V1Endpoint item);

  public io.kubernetes.client.openapi.models.V1EndpointSliceFluent.EndpointsNested<A> editEndpoint(
      java.lang.Integer index);

  public io.kubernetes.client.openapi.models.V1EndpointSliceFluent.EndpointsNested<A>
      editFirstEndpoint();

  public io.kubernetes.client.openapi.models.V1EndpointSliceFluent.EndpointsNested<A>
      editLastEndpoint();

  public io.kubernetes.client.openapi.models.V1EndpointSliceFluent.EndpointsNested<A>
      editMatchingEndpoint(
          java.util.function.Predicate<io.kubernetes.client.openapi.models.V1EndpointBuilder>
              predicate);

  public java.lang.String getKind();

  public A withKind(java.lang.String kind);

  public java.lang.Boolean hasKind();

  /**
   * This method has been deprecated, please use method buildMetadata instead.
   *
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public V1ObjectMeta getMetadata();

  public io.kubernetes.client.openapi.models.V1ObjectMeta buildMetadata();

  public A withMetadata(io.kubernetes.client.openapi.models.V1ObjectMeta metadata);

  public java.lang.Boolean hasMetadata();

  public V1EndpointSliceFluent.MetadataNested<A> withNewMetadata();

  public io.kubernetes.client.openapi.models.V1EndpointSliceFluent.MetadataNested<A>
      withNewMetadataLike(io.kubernetes.client.openapi.models.V1ObjectMeta item);

  public io.kubernetes.client.openapi.models.V1EndpointSliceFluent.MetadataNested<A> editMetadata();

  public io.kubernetes.client.openapi.models.V1EndpointSliceFluent.MetadataNested<A>
      editOrNewMetadata();

  public io.kubernetes.client.openapi.models.V1EndpointSliceFluent.MetadataNested<A>
      editOrNewMetadataLike(io.kubernetes.client.openapi.models.V1ObjectMeta item);

  public A addToPorts(java.lang.Integer index, DiscoveryV1EndpointPort item);

  public A setToPorts(
      java.lang.Integer index, io.kubernetes.client.openapi.models.DiscoveryV1EndpointPort item);

  public A addToPorts(io.kubernetes.client.openapi.models.DiscoveryV1EndpointPort... items);

  public A addAllToPorts(
      java.util.Collection<io.kubernetes.client.openapi.models.DiscoveryV1EndpointPort> items);

  public A removeFromPorts(io.kubernetes.client.openapi.models.DiscoveryV1EndpointPort... items);

  public A removeAllFromPorts(
      java.util.Collection<io.kubernetes.client.openapi.models.DiscoveryV1EndpointPort> items);

  public A removeMatchingFromPorts(
      java.util.function.Predicate<DiscoveryV1EndpointPortBuilder> predicate);

  /**
   * This method has been deprecated, please use method buildPorts instead.
   *
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.kubernetes.client.openapi.models.DiscoveryV1EndpointPort> getPorts();

  public java.util.List<io.kubernetes.client.openapi.models.DiscoveryV1EndpointPort> buildPorts();

  public io.kubernetes.client.openapi.models.DiscoveryV1EndpointPort buildPort(
      java.lang.Integer index);

  public io.kubernetes.client.openapi.models.DiscoveryV1EndpointPort buildFirstPort();

  public io.kubernetes.client.openapi.models.DiscoveryV1EndpointPort buildLastPort();

  public io.kubernetes.client.openapi.models.DiscoveryV1EndpointPort buildMatchingPort(
      java.util.function.Predicate<
              io.kubernetes.client.openapi.models.DiscoveryV1EndpointPortBuilder>
          predicate);

  public java.lang.Boolean hasMatchingPort(
      java.util.function.Predicate<
              io.kubernetes.client.openapi.models.DiscoveryV1EndpointPortBuilder>
          predicate);

  public A withPorts(
      java.util.List<io.kubernetes.client.openapi.models.DiscoveryV1EndpointPort> ports);

  public A withPorts(io.kubernetes.client.openapi.models.DiscoveryV1EndpointPort... ports);

  public java.lang.Boolean hasPorts();

  public V1EndpointSliceFluent.PortsNested<A> addNewPort();

  public io.kubernetes.client.openapi.models.V1EndpointSliceFluent.PortsNested<A> addNewPortLike(
      io.kubernetes.client.openapi.models.DiscoveryV1EndpointPort item);

  public io.kubernetes.client.openapi.models.V1EndpointSliceFluent.PortsNested<A> setNewPortLike(
      java.lang.Integer index, io.kubernetes.client.openapi.models.DiscoveryV1EndpointPort item);

  public io.kubernetes.client.openapi.models.V1EndpointSliceFluent.PortsNested<A> editPort(
      java.lang.Integer index);

  public io.kubernetes.client.openapi.models.V1EndpointSliceFluent.PortsNested<A> editFirstPort();

  public io.kubernetes.client.openapi.models.V1EndpointSliceFluent.PortsNested<A> editLastPort();

  public io.kubernetes.client.openapi.models.V1EndpointSliceFluent.PortsNested<A> editMatchingPort(
      java.util.function.Predicate<
              io.kubernetes.client.openapi.models.DiscoveryV1EndpointPortBuilder>
          predicate);

  public interface EndpointsNested<N>
      extends Nested<N>, V1EndpointFluent<V1EndpointSliceFluent.EndpointsNested<N>> {
    public N and();

    public N endEndpoint();
  }

  public interface MetadataNested<N>
      extends io.kubernetes.client.fluent.Nested<N>,
          V1ObjectMetaFluent<V1EndpointSliceFluent.MetadataNested<N>> {
    public N and();

    public N endMetadata();
  }

  public interface PortsNested<N>
      extends io.kubernetes.client.fluent.Nested<N>,
          DiscoveryV1EndpointPortFluent<V1EndpointSliceFluent.PortsNested<N>> {
    public N and();

    public N endPort();
  }
}
