/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.spring;

import io.kotlintest.Spec;
import io.kotlintest.extensions.DiscoveryExtension;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextManager;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007H\u0016\u00a8\u0006\b"}, d2={"Lio/kotlintest/spring/SpringAutowireConstructorExtension;", "Lio/kotlintest/extensions/DiscoveryExtension;", "()V", "instantiate", "Lio/kotlintest/Spec;", "T", "clazz", "Lkotlin/reflect/KClass;", "kotlintest-extensions-spring"})
public final class SpringAutowireConstructorExtension
implements DiscoveryExtension {
    public static final SpringAutowireConstructorExtension INSTANCE;

    @Nullable
    public <T extends Spec> Spec instantiate(@NotNull KClass<T> clazz) {
        Spec spec;
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        KFunction constructor = KClasses.getPrimaryConstructor(clazz);
        if (constructor == null || constructor.getParameters().isEmpty()) {
            spec = null;
        } else {
            ApplicationContext ac;
            TestContextManager manager = new TestContextManager(JvmClassMappingKt.getJavaClass(clazz));
            TestContext testContext = manager.getTestContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)testContext, (String)"manager.testContext");
            ApplicationContext applicationContext = ac = testContext.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationContext, (String)"ac");
            Object object = applicationContext.getAutowireCapableBeanFactory().autowire(JvmClassMappingKt.getJavaClass(clazz), 3, true);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.kotlintest.Spec");
            }
            spec = (Spec)object;
        }
        return spec;
    }

    private SpringAutowireConstructorExtension() {
    }

    static {
        SpringAutowireConstructorExtension springAutowireConstructorExtension;
        INSTANCE = springAutowireConstructorExtension = new SpringAutowireConstructorExtension();
    }

    @NotNull
    public List<KClass<? extends Spec>> afterScan(@NotNull List<? extends KClass<? extends Spec>> classes) {
        Intrinsics.checkParameterIsNotNull(classes, (String)"classes");
        return DiscoveryExtension.DefaultImpls.afterScan((DiscoveryExtension)this, classes);
    }
}

