/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.fragments.task.handler.log.api.model;

import io.knotx.fragments.task.handler.log.api.model.GraphNodeErrorLogConverter;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@DataObject(generateConverter=true)
public class GraphNodeErrorLog {
    private String className;
    private String message;
    private JsonArray stacktrace;

    public GraphNodeErrorLog() {
    }

    public static GraphNodeErrorLog newInstance(Throwable error) {
        JsonArray stackTraceLogs = new JsonArray(Arrays.stream(error.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.toList()));
        return new GraphNodeErrorLog().setClassName(error.getClass().getCanonicalName()).setMessage(error.getMessage()).setStacktrace(stackTraceLogs);
    }

    public GraphNodeErrorLog(JsonObject json) {
        GraphNodeErrorLogConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        GraphNodeErrorLogConverter.toJson(this, result);
        return result;
    }

    public String getClassName() {
        return this.className;
    }

    public GraphNodeErrorLog setClassName(String className) {
        this.className = className;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public GraphNodeErrorLog setMessage(String message) {
        this.message = message;
        return this;
    }

    public JsonArray getStacktrace() {
        return this.stacktrace;
    }

    public GraphNodeErrorLog setStacktrace(JsonArray stacktrace) {
        this.stacktrace = stacktrace;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphNodeErrorLog that = (GraphNodeErrorLog)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.message, that.message) && Objects.equals(this.stacktrace, that.stacktrace);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.message, this.stacktrace);
    }

    public String toString() {
        return "GraphNodeErrorLog{className='" + this.className + '\'' + ", message='" + this.message + '\'' + ", stacktrace=" + this.stacktrace + '}';
    }
}

