/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.fragments.task.handler.log.api.model;

import io.knotx.fragments.task.api.NodeType;
import io.knotx.fragments.task.handler.log.api.model.GraphNodeExecutionLogConverter;
import io.knotx.fragments.task.handler.log.api.model.GraphNodeOperationLog;
import io.knotx.fragments.task.handler.log.api.model.GraphNodeResponseLog;
import io.knotx.fragments.task.handler.log.api.model.LoggedNodeStatus;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@DataObject(generateConverter=true)
public class GraphNodeExecutionLog {
    private String id;
    private NodeType type = NodeType.SINGLE;
    private String label = "";
    private long started;
    private long finished;
    private List<GraphNodeExecutionLog> subtasks = new ArrayList<GraphNodeExecutionLog>();
    private GraphNodeOperationLog operation = GraphNodeOperationLog.empty();
    private Map<String, GraphNodeExecutionLog> on = new HashMap<String, GraphNodeExecutionLog>();
    private LoggedNodeStatus status = LoggedNodeStatus.UNPROCESSED;
    private GraphNodeResponseLog response = new GraphNodeResponseLog();

    public static GraphNodeExecutionLog newInstance(String id) {
        return new GraphNodeExecutionLog().setId(id);
    }

    public static GraphNodeExecutionLog newInstance(String id, NodeType type, String label, long started, long finished, List<GraphNodeExecutionLog> subtasks, GraphNodeOperationLog operation, Map<String, GraphNodeExecutionLog> on) {
        return new GraphNodeExecutionLog().setId(id).setType(type).setLabel(label).setStarted(started).setFinished(finished).setSubtasks(subtasks).setOperation(operation).setOn(on).setResponse(new GraphNodeResponseLog());
    }

    public GraphNodeExecutionLog() {
    }

    public GraphNodeExecutionLog(JsonObject jsonObject) {
        GraphNodeExecutionLogConverter.fromJson((Iterable<Map.Entry<String, Object>>)jsonObject, this);
    }

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        GraphNodeExecutionLogConverter.toJson(this, result);
        return result;
    }

    public String getId() {
        return this.id;
    }

    public GraphNodeExecutionLog setId(String id) {
        this.id = id;
        return this;
    }

    public NodeType getType() {
        return this.type;
    }

    public GraphNodeExecutionLog setType(NodeType type) {
        this.type = type;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public GraphNodeExecutionLog setLabel(String label) {
        this.label = label;
        return this;
    }

    public long getStarted() {
        return this.started;
    }

    public GraphNodeExecutionLog setStarted(long started) {
        this.started = started;
        return this;
    }

    public long getFinished() {
        return this.finished;
    }

    public GraphNodeExecutionLog setFinished(long finished) {
        this.finished = finished;
        return this;
    }

    public List<GraphNodeExecutionLog> getSubtasks() {
        return this.subtasks;
    }

    public GraphNodeExecutionLog setSubtasks(List<GraphNodeExecutionLog> subtasks) {
        this.subtasks = subtasks;
        return this;
    }

    public Optional<GraphNodeExecutionLog> getSubtask(String label) {
        return this.subtasks.stream().filter(node -> label.equals(node.getLabel())).findFirst();
    }

    public GraphNodeOperationLog getOperation() {
        return this.operation;
    }

    public GraphNodeExecutionLog setOperation(GraphNodeOperationLog operation) {
        this.operation = operation;
        return this;
    }

    public Map<String, GraphNodeExecutionLog> getOn() {
        return this.on;
    }

    public GraphNodeExecutionLog setOn(Map<String, GraphNodeExecutionLog> on) {
        this.on = on;
        return this;
    }

    public LoggedNodeStatus getStatus() {
        return this.status;
    }

    public GraphNodeExecutionLog setStatus(LoggedNodeStatus status) {
        this.status = status;
        return this;
    }

    public GraphNodeResponseLog getResponse() {
        return this.response;
    }

    public GraphNodeExecutionLog setResponse(GraphNodeResponseLog response) {
        this.response = response;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphNodeExecutionLog that = (GraphNodeExecutionLog)o;
        return Objects.equals(this.id, that.id) && this.type == that.type && Objects.equals(this.label, that.label) && Objects.equals(this.subtasks, that.subtasks) && Objects.equals(this.operation, that.operation) && Objects.equals(this.on, that.on) && this.status == that.status && Objects.equals(this.response, that.response);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.label, this.subtasks, this.operation, this.on, this.status, this.response});
    }

    public String toString() {
        return "GraphNodeExecutionLog{id='" + this.id + '\'' + ", type=" + this.type + ", label='" + this.label + '\'' + ", subtasks=" + this.subtasks + ", operation=" + this.operation + ", on=" + this.on + ", status=" + (Object)((Object)this.status) + ", response=" + this.response + '}';
    }
}

