/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.fragments.handler.api.domain.payload;

import io.knotx.fragments.handler.api.domain.payload.ActionResponseError;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;

@DataObject
public class ActionResponse {
    static final String KEY = "_response";
    private static final String SUCCESS_KEY = "success";
    private static final String METADATA_KEY = "metadata";
    private boolean success;
    private ActionResponseError error;
    private JsonObject metadata;

    ActionResponse() {
        this.metadata = new JsonObject();
    }

    public ActionResponse(JsonObject json) {
        this.success = json.getBoolean(SUCCESS_KEY);
        if (json.containsKey("error")) {
            this.error = new ActionResponseError(json.getJsonObject("error"));
        }
        this.metadata = json.getJsonObject(METADATA_KEY);
    }

    public static ActionResponse success() {
        ActionResponse response = new ActionResponse();
        response.success = true;
        return response;
    }

    public static ActionResponse error(String errorCode) {
        return ActionResponse.error(errorCode, null);
    }

    public static ActionResponse error(String errorCode, String errorMessage) {
        ActionResponse response = new ActionResponse();
        response.success = false;
        response.error = new ActionResponseError(errorCode, errorMessage);
        return response;
    }

    public ActionResponse appendMetadata(String key, Object value) {
        this.metadata.put(key, value);
        return this;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public ActionResponseError getError() {
        return this.error;
    }

    public JsonObject getMetadata() {
        return this.metadata.copy();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put(SUCCESS_KEY, Boolean.valueOf(this.success));
        if (this.error != null) {
            json.put("error", this.error.toJson());
        }
        json.put(METADATA_KEY, this.metadata);
        return json;
    }

    public String toString() {
        return "ActionResponse{success=" + this.success + ", error=" + this.error + ", metadata=" + this.metadata + '}';
    }
}

