/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.fragments.handler.api.domain.payload;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;

@DataObject
public class ActionRequest {
    static final String KEY = "_request";
    private static final String TYPE_KEY = "type";
    private static final String SOURCE_KEY = "source";
    private static final String METADATA_KEY = "metadata";
    private String type;
    private String source;
    private JsonObject metadata;

    public ActionRequest(String type, String source) {
        this.type = type;
        this.source = source;
        this.metadata = new JsonObject();
    }

    public ActionRequest(JsonObject jsonObject) {
        this.type = jsonObject.getString(TYPE_KEY);
        this.source = jsonObject.getString(SOURCE_KEY);
        this.metadata = jsonObject.getJsonObject(METADATA_KEY);
    }

    public ActionRequest appendMetadata(String key, Object value) {
        this.metadata.put(key, value);
        return this;
    }

    public String getType() {
        return this.type;
    }

    public String getSource() {
        return this.source;
    }

    public JsonObject getMetadata() {
        return this.metadata.copy();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put(TYPE_KEY, this.type);
        json.put(SOURCE_KEY, this.source);
        json.put(METADATA_KEY, this.metadata);
        return json;
    }

    public String toString() {
        return "ActionRequest{type='" + this.type + '\'' + ", source='" + this.source + '\'' + ", metadata=" + this.metadata + '}';
    }
}

