/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.fragments.handler.api.domain.payload;

import io.knotx.fragments.handler.api.domain.payload.ActionRequest;
import io.knotx.fragments.handler.api.domain.payload.ActionResponse;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;

@DataObject
public class ActionPayload {
    static final String RESULT_KEY = "_result";
    private final ActionRequest request;
    private final ActionResponse response;
    private final Object result;

    ActionPayload(ActionRequest request, ActionResponse response, Object result) {
        this.request = request;
        this.response = response;
        this.result = result;
    }

    public ActionPayload(JsonObject jsonObject) {
        this.request = new ActionRequest(jsonObject.getJsonObject("_request"));
        this.response = new ActionResponse(jsonObject.getJsonObject("_response"));
        this.result = jsonObject.getValue(RESULT_KEY);
    }

    public static ActionPayload success(ActionRequest request, Object result) {
        return new ActionPayload(request, ActionResponse.success(), result);
    }

    public static ActionPayload error(ActionRequest request, String errorCode, String errorMessage) {
        return new ActionPayload(request, ActionResponse.error(errorCode, errorMessage), null);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put("_request", this.request.toJson());
        json.put("_response", this.response.toJson());
        json.put(RESULT_KEY, this.result);
        return json;
    }

    public ActionRequest getRequest() {
        return this.request;
    }

    public ActionResponse getResponse() {
        return this.response;
    }

    public Object getResult() {
        return this.result;
    }

    public String toString() {
        return "ActionPayload{request=" + this.request + ", response=" + this.response + ", result=" + this.result + '}';
    }
}

