/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.fragments.handler.api.domain;

import io.knotx.fragments.api.Fragment;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@DataObject
public class FragmentResult {
    public static final String SUCCESS_TRANSITION = "_success";
    public static final String ERROR_TRANSITION = "_error";
    private static final String FRAGMENT_KEY = "fragment";
    private static final String TRANSITION_KEY = "transition";
    private Fragment fragment;
    private String transition;

    public FragmentResult(Fragment fragment, String transition) {
        this.fragment = fragment;
        this.transition = transition;
    }

    public FragmentResult(JsonObject json) {
        this.fragment = new Fragment(json.getJsonObject(FRAGMENT_KEY));
        this.transition = json.getString(TRANSITION_KEY);
    }

    public JsonObject toJson() {
        return new JsonObject().put(FRAGMENT_KEY, this.fragment.toJson()).put(TRANSITION_KEY, this.transition);
    }

    public Fragment getFragment() {
        return this.fragment;
    }

    public String getTransition() {
        if (StringUtils.isBlank((CharSequence)this.transition)) {
            return SUCCESS_TRANSITION;
        }
        return this.transition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentResult that = (FragmentResult)o;
        return Objects.equals(this.fragment, that.fragment) && Objects.equals(this.transition, that.transition);
    }

    public int hashCode() {
        return Objects.hash(this.fragment, this.transition);
    }

    public String toString() {
        return "FragmentResult{fragment=" + this.fragment + ", transition='" + this.transition + '\'' + '}';
    }
}

