/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.fragments.handler.api.domain;

import io.knotx.fragments.api.Fragment;
import io.knotx.server.api.context.ClientRequest;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.Objects;

@DataObject
public class FragmentContext {
    private static final String FRAGMENT_KEY = "fragment";
    private static final String CLIENT_REQUEST_KEY = "clientRequest";
    private final Fragment fragment;
    private final ClientRequest clientRequest;

    public FragmentContext(Fragment fragment, ClientRequest clientRequest) {
        this.fragment = fragment;
        this.clientRequest = clientRequest;
    }

    public FragmentContext(JsonObject json) {
        this.fragment = new Fragment(json.getJsonObject(FRAGMENT_KEY));
        this.clientRequest = new ClientRequest(json.getJsonObject(CLIENT_REQUEST_KEY));
    }

    public JsonObject toJson() {
        return new JsonObject().put(FRAGMENT_KEY, this.fragment.toJson()).put(CLIENT_REQUEST_KEY, this.clientRequest.toJson());
    }

    public Fragment getFragment() {
        return this.fragment;
    }

    public ClientRequest getClientRequest() {
        return this.clientRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentContext that = (FragmentContext)o;
        return Objects.equals(this.fragment, that.fragment) && Objects.equals(this.clientRequest, that.clientRequest);
    }

    public int hashCode() {
        return Objects.hash(this.fragment, this.clientRequest);
    }

    public String toString() {
        return "FragmentContext{fragment=" + this.fragment + ", clientRequest=" + this.clientRequest + '}';
    }
}

