/*
 * Decompiled with CFR 0.152.
 */
package io.klerch.alexa.test.response;

import com.amazon.speech.json.SpeechletResponseEnvelope;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import io.klerch.alexa.test.client.AlexaSession;
import io.klerch.alexa.test.request.AlexaRequest;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minidev.json.JSONArray;
import org.apache.commons.lang3.Validate;
import org.apache.log4j.Logger;

public class AlexaResponse {
    private static final Configuration config = Configuration.builder().options(Option.ALWAYS_RETURN_LIST).options(Option.DEFAULT_PATH_LEAF_TO_NULL).options(Option.SUPPRESS_EXCEPTIONS).build();
    private static final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final Logger log = Logger.getLogger(AlexaResponse.class);
    final SpeechletResponseEnvelope envelope;
    final String responsePayload;
    final String requestPayload;
    final AlexaRequest request;

    public AlexaResponse(AlexaRequest request, String requestPayload, String responsePayload) {
        this.request = request;
        this.requestPayload = requestPayload;
        this.responsePayload = responsePayload;
        try {
            this.envelope = mapper.readValue(responsePayload, SpeechletResponseEnvelope.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Invalid response format from Lambda function.", e);
        }
    }

    public SpeechletResponseEnvelope getResponseEnvelope() {
        return this.envelope;
    }

    public AlexaRequest getRequest() {
        return this.request;
    }

    public Optional<String> get(String jsonPath) {
        List result;
        if (!jsonPath.startsWith("$")) {
            jsonPath = "$" + jsonPath;
        }
        if ((result = (List)JsonPath.using(config).parse(this.responsePayload).read(jsonPath, new com.jayway.jsonpath.Predicate[0])) == null || result.isEmpty()) {
            result = (List)JsonPath.using(config).parse(this.requestPayload).read(jsonPath, new com.jayway.jsonpath.Predicate[0]);
        }
        return Optional.ofNullable(result).filter(l -> !l.isEmpty()).map(l -> (String)l.get(0));
    }

    public boolean isEmpty() {
        return this.request == null;
    }

    public AlexaResponse assertExecutionTimeLessThan(long millis) {
        String assertionText = String.format("Execution is not longer than %s ms.", millis);
        long executionMillis = this.request.getSession().getClient().getLastExecutionMillis();
        Validate.inclusiveBetween(0L, millis, Long.valueOf(executionMillis), "[FAILED] Assertion '%1Ss' is FALSE. Was %2Ss ms.", assertionText, executionMillis);
        log.info(String.format("->[TRUE] %s", assertionText));
        return this;
    }

    public AlexaResponse assertThat(Predicate<SpeechletResponseEnvelope> responseEnvelope) {
        String assertionText = "Custom predicate ifMatch.";
        return this.validate(this.is(responseEnvelope), "Custom predicate ifMatch.");
    }

    public AlexaResponse assertThat(String jsonPathExpression) {
        return this.validate(this.is(jsonPathExpression), "JSON path expression " + jsonPathExpression);
    }

    public AlexaResponse assertTrue(String jsonPathExpression) {
        return this.assertThat(jsonPathExpression + " == true");
    }

    public AlexaResponse assertFalse(String jsonPathExpression) {
        return this.assertThat(jsonPathExpression + " == false");
    }

    public AlexaResponse assertExists(String jsonPathExpression) {
        return this.assertThat(jsonPathExpression);
    }

    public AlexaResponse assertNotExists(String jsonPathExpression) {
        return this.assertExists("!(" + jsonPathExpression + ")");
    }

    public AlexaResponse assertEquals(String jsonPathExpression, Object o) {
        String s = o instanceof String ? "'" + o + "'" : o.toString();
        return this.assertThat(jsonPathExpression + " == " + s);
    }

    public AlexaResponse assertContains(String jsonPathExpression, String s) {
        return this.assertThat(jsonPathExpression + " =~ /.*" + s + ".*/i");
    }

    public boolean is(Predicate<SpeechletResponseEnvelope> responseEnvelope) {
        return responseEnvelope.test(this.envelope);
    }

    public boolean is(String jsonPathExpression) {
        String conditionalText = String.format("%1$s is TRUE.", jsonPathExpression);
        if (!jsonPathExpression.startsWith("?(@.")) {
            jsonPathExpression = "?(@." + jsonPathExpression + ")";
        }
        String jsonPath = "$.response[" + jsonPathExpression + "]";
        Object o = JsonPath.using(config).parse("{ \"response\" : [ " + this.responsePayload + " ]}").read(jsonPath, new com.jayway.jsonpath.Predicate[0]);
        return this.result(o != null && o instanceof JSONArray && !((JSONArray)o).isEmpty(), conditionalText);
    }

    public AlexaResponse is(Predicate<SpeechletResponseEnvelope> responseEnvelope, Consumer<AlexaSession> followUp) {
        if (this.is(responseEnvelope)) {
            followUp.accept(this.request.getSession());
        }
        return this;
    }

    public AlexaResponse ifIs(String jsonPathExpression, Consumer<AlexaSession> followUp) {
        if (this.is(jsonPathExpression)) {
            followUp.accept(this.request.getSession());
        }
        return this;
    }

    public boolean isTrue(String jsonPathExpression) {
        return this.is(jsonPathExpression + " == true");
    }

    public boolean isFalse(String jsonPathExpression) {
        return this.is(jsonPathExpression + " == false");
    }

    public boolean exists(String jsonPathExpression) {
        return this.is(jsonPathExpression);
    }

    public boolean notExists(String jsonPathExpression) {
        return this.is("!(" + jsonPathExpression + ")");
    }

    public boolean equals(String jsonPathExpression, Object o) {
        String s = o instanceof String ? "'" + o + "'" : o.toString();
        return this.is(jsonPathExpression + " == " + s);
    }

    public boolean contains(String jsonPathExpression, String s) {
        return this.is(jsonPathExpression + " =~ /.*" + s + ".*/i");
    }

    public AlexaResponse ifTrue(String jsonPathExpression, Consumer<AlexaSession> followUp) {
        return this.ifIs(jsonPathExpression + " == true", followUp);
    }

    public AlexaResponse ifFalse(String jsonPathExpression, Consumer<AlexaSession> followUp) {
        return this.ifIs(jsonPathExpression + " == false", followUp);
    }

    public AlexaResponse ifExists(String jsonPathExpression, Consumer<AlexaSession> followUp) {
        return this.ifIs(jsonPathExpression, followUp);
    }

    public AlexaResponse ifNotExists(String jsonPathExpression, Consumer<AlexaSession> followUp) {
        return this.ifIs("!(" + jsonPathExpression + ")", followUp);
    }

    public AlexaResponse ifEquals(String jsonPathExpression, Object o, Consumer<AlexaSession> followUp) {
        String s = o instanceof String ? "'" + o + "'" : o.toString();
        return this.ifIs(jsonPathExpression + " == " + s, followUp);
    }

    public AlexaResponse ifContains(String jsonPathExpression, String s, Consumer<AlexaSession> followUp) {
        return this.ifIs(jsonPathExpression + " =~ /.*" + s + ".*/i", followUp);
    }

    public AlexaSession done() {
        return this.request.getSession();
    }

    private AlexaResponse validate(boolean assertionResult, String assertionText) {
        Validate.isTrue(assertionResult, "[FAILED] Assertion '%1$s' is FALSE.", assertionText);
        return this;
    }

    private boolean result(boolean conditionalResult, String conditionalText) {
        String result = conditionalResult ? "TRUE" : "FALSE";
        log.info(String.format("->[%1$s] %2$s", result, conditionalText));
        return conditionalResult;
    }
}

