/*
 * Decompiled with CFR 0.152.
 */
package io.klerch.alexa.test.request;

import com.amazon.speech.slu.Intent;
import com.amazon.speech.slu.Slot;
import com.amazon.speech.speechlet.CoreSpeechletRequest;
import com.amazon.speech.speechlet.IntentRequest;
import io.klerch.alexa.test.client.AlexaSession;
import io.klerch.alexa.test.request.AlexaRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AlexaIntentRequest
extends AlexaRequest {
    private final String intentName;
    private final Map<String, Slot> slots = new HashMap<String, Slot>();

    public AlexaIntentRequest(AlexaSession actor, String intentName) {
        super(actor);
        this.intentName = intentName;
    }

    public String getIntentName() {
        return this.intentName;
    }

    public String getSlotSummary() {
        List slotValues = this.slots.values().stream().map(slot -> slot.getName() + ": " + slot.getValue()).collect(Collectors.toList());
        return slotValues.isEmpty() ? "" : "{ " + String.join((CharSequence)", ", slotValues) + " }";
    }

    @Override
    public boolean expectsResponse() {
        return true;
    }

    public AlexaIntentRequest withSlot(String slotName, Object slotValue) {
        return this.withSlots(Collections.singletonList(Slot.builder().withName(slotName).withValue(String.valueOf(slotValue)).build()));
    }

    public AlexaIntentRequest withSlots(Map<String, Slot> slots) {
        this.slots.putAll(slots);
        return this;
    }

    public AlexaIntentRequest withSlots(List<Slot> slots) {
        slots.forEach(slot -> this.slots.putIfAbsent(slot.getName(), (Slot)slot));
        return this;
    }

    @Override
    public CoreSpeechletRequest getSpeechletRequest() {
        Intent intent = Intent.builder().withName(this.intentName).withSlots(this.slots).build();
        return ((IntentRequest.Builder)((IntentRequest.Builder)((IntentRequest.Builder)IntentRequest.builder().withLocale(this.session.getClient().getLocale())).withRequestId(AlexaIntentRequest.generateRequestId())).withIntent(intent).withTimestamp(this.session.getClient().getCurrentTimestamp())).build();
    }
}

