/*
 * Decompiled with CFR 0.152.
 */
package io.klerch.alexa.test.client.endpoint;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.klerch.alexa.test.client.endpoint.AlexaApiEndpoint;
import io.klerch.alexa.test.request.AlexaRequest;
import io.klerch.alexa.test.request.AlexaUtteranceRequest;
import io.klerch.alexa.test.response.AlexaResponse;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpResponse;

public class AlexaSimulationApiEndpoint
extends AlexaApiEndpoint {
    @JsonIgnore
    private static final String DEFAULT_LOCALE = Locale.US.toLanguageTag();
    @JsonProperty
    Input input = new Input();
    @JsonProperty
    final Device device = new Device();

    AlexaSimulationApiEndpoint(AlexaSimulationApiEndpointBuilder builder) {
        super(builder);
        this.device.locale = builder.locale;
    }

    @Override
    public String getService() {
        return "simulations";
    }

    public static AlexaSimulationApiEndpointBuilder create(HashMap<Object, Object> endpointConfiguration) {
        return new AlexaSimulationApiEndpointBuilder(endpointConfiguration);
    }

    public static AlexaSimulationApiEndpointBuilder create(String skillId) {
        return new AlexaSimulationApiEndpointBuilder(skillId);
    }

    @Override
    public Optional<AlexaResponse> fire(AlexaRequest request, String payload) {
        if (!(request instanceof AlexaUtteranceRequest)) {
            log.info("Skip " + request.getClass().getName() + " as it is not supported by Simulation-Api endpoint.");
            return Optional.empty();
        }
        return super.fire(request, payload);
    }

    @Override
    HttpResponse fire(String utterance) {
        try {
            this.input.content = utterance;
            String requestPayload = om.writeValueAsString(this);
            return super.fire(requestPayload);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not build request for Simulation API. ", e);
        }
    }

    public static class AlexaSimulationApiEndpointBuilder
    extends AlexaApiEndpoint.AlexaApiEndpointBuilder<AlexaSimulationApiEndpoint> {
        String locale;

        AlexaSimulationApiEndpointBuilder(String skillId) {
            super(skillId);
        }

        AlexaSimulationApiEndpointBuilder(HashMap<Object, Object> endpointConfiguration) {
            super(endpointConfiguration);
            this.locale = endpointConfiguration.getOrDefault("locale", DEFAULT_LOCALE).toString();
        }

        public AlexaApiEndpoint.AlexaApiEndpointBuilder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        public AlexaApiEndpoint.AlexaApiEndpointBuilder withLocale(Locale locale) {
            return this.withLocale(locale.toLanguageTag());
        }

        @Override
        public AlexaSimulationApiEndpoint build() {
            this.preBuild();
            Validate.notBlank(this.locale, "Locale must be provided.", new Object[0]);
            return new AlexaSimulationApiEndpoint(this);
        }
    }

    private class Input {
        @JsonProperty
        private String content;

        private Input() {
        }
    }

    private class Device {
        @JsonProperty
        private String locale;

        private Device() {
        }
    }
}

