/*
 * Decompiled with CFR 0.152.
 */
package io.klerch.alexa.test.client.endpoint;

import com.amazonaws.services.lambda.runtime.ClientContext;
import com.amazonaws.services.lambda.runtime.CognitoIdentity;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.LambdaLogger;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import io.klerch.alexa.test.client.endpoint.AlexaEndpoint;
import io.klerch.alexa.test.request.AlexaRequest;
import io.klerch.alexa.test.response.AlexaResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.apache.log4j.Logger;

public class AlexaRequestStreamHandlerEndpoint
implements AlexaEndpoint {
    private static final Logger log = Logger.getLogger(AlexaRequestStreamHandlerEndpoint.class);
    private final RequestStreamHandler requestStreamHandler;
    private final Context context;

    AlexaRequestStreamHandlerEndpoint(AlexaRequestStreamHandlerEndpointBuilder builder) {
        this.requestStreamHandler = builder.requestStreamHandler;
        this.context = builder.context;
    }

    public RequestStreamHandler getRequestStreamHandler() {
        return this.requestStreamHandler;
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public Optional<AlexaResponse> fire(AlexaRequest request, String payload) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(payload.getBytes());
        try {
            log.info(String.format("->[INFO] Call request handler '%s'.", this.requestStreamHandler.getClass().getCanonicalName()));
            log.debug(String.format("->[INFO] with request payload '%s'.", payload));
            this.requestStreamHandler.handleRequest(inputStream, outputStream, this.context);
        }
        catch (IOException e) {
            String msg = String.format("Error on invoking request stream handler. %s", e.getMessage());
            log.error(String.format("->[ERROR] %s", msg));
            throw new RuntimeException(msg, e);
        }
        return request.expectsResponse() ? Optional.of(new AlexaResponse(request, payload, new String(outputStream.toByteArray()))) : Optional.empty();
    }

    static AlexaRequestStreamHandlerEndpointBuilder create(HashMap<Object, Object> endpointConfiguration) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Validate.notEmpty(endpointConfiguration, "Endpoint configuration must not be empty. At least the class-attribute is necessary for the RequestStreamHandler.", new Object[0]);
        Validate.isTrue(endpointConfiguration.containsKey("class"), "class-attribute is missing in your Endpoint configuration for the RequestStreamHandler.", new Object[0]);
        return AlexaRequestStreamHandlerEndpoint.create(Class.forName(endpointConfiguration.get("class").toString()).asSubclass(RequestStreamHandler.class));
    }

    public static <T extends RequestStreamHandler> AlexaRequestStreamHandlerEndpointBuilder create(Class<T> clazz) throws IllegalAccessException, InstantiationException {
        return AlexaRequestStreamHandlerEndpoint.create((RequestStreamHandler)clazz.newInstance());
    }

    public static AlexaRequestStreamHandlerEndpointBuilder create(RequestStreamHandler streamHandler) {
        return new AlexaRequestStreamHandlerEndpointBuilder(streamHandler);
    }

    public static class AlexaRequestStreamHandlerEndpointBuilder {
        RequestStreamHandler requestStreamHandler;
        Context context;

        AlexaRequestStreamHandlerEndpointBuilder(RequestStreamHandler requestStreamHandler) {
            this.requestStreamHandler = requestStreamHandler;
        }

        public AlexaRequestStreamHandlerEndpointBuilder withContext(Context context) {
            this.context = context;
            return this;
        }

        public AlexaRequestStreamHandlerEndpoint build() {
            Validate.notNull(this.requestStreamHandler, "Request stream handler must not be null.", new Object[0]);
            if (this.context == null) {
                this.context = this.getContext();
            }
            return new AlexaRequestStreamHandlerEndpoint(this);
        }

        private Context getContext() {
            return new Context(){

                @Override
                public String getAwsRequestId() {
                    return null;
                }

                @Override
                public String getLogGroupName() {
                    return null;
                }

                @Override
                public String getLogStreamName() {
                    return null;
                }

                @Override
                public String getFunctionName() {
                    return null;
                }

                @Override
                public CognitoIdentity getIdentity() {
                    return null;
                }

                @Override
                public ClientContext getClientContext() {
                    return null;
                }

                @Override
                public int getRemainingTimeInMillis() {
                    return 0;
                }

                @Override
                public int getMemoryLimitInMB() {
                    return 0;
                }

                @Override
                public LambdaLogger getLogger() {
                    return null;
                }
            };
        }
    }
}

