/*
 * Decompiled with CFR 0.152.
 */
package io.klerch.alexa.test.client.endpoint;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.AWSLambdaClient;
import com.amazonaws.services.lambda.model.InvocationType;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.amazonaws.services.lambda.model.InvokeResult;
import io.klerch.alexa.test.client.endpoint.AlexaEndpoint;
import io.klerch.alexa.test.request.AlexaRequest;
import io.klerch.alexa.test.response.AlexaResponse;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.apache.log4j.Logger;

public class AlexaLambdaEndpoint
implements AlexaEndpoint {
    private static final Logger log = Logger.getLogger(AlexaLambdaEndpoint.class);
    private final AWSLambda lambdaClient;
    private final String lambdaFunctionName;

    AlexaLambdaEndpoint(AlexaLambdaEndpointBuilder builder) {
        this.lambdaClient = builder.lambdaClient;
        this.lambdaFunctionName = builder.lambdaFunctionName;
    }

    public String getLambdaFunctionName() {
        return this.lambdaFunctionName;
    }

    public AWSLambda getLambdaClient() {
        return this.lambdaClient;
    }

    @Override
    public Optional<AlexaResponse> fire(AlexaRequest request, String payload) {
        InvocationType invocationType = request.expectsResponse() ? InvocationType.RequestResponse : InvocationType.Event;
        InvokeRequest invokeRequest = new InvokeRequest().withInvocationType(invocationType).withFunctionName(this.lambdaFunctionName).withPayload(payload);
        log.info(String.format("->[INFO] Invoke lambda function '%s'.", this.lambdaFunctionName));
        log.debug(String.format("->[INFO] with request payload '%s'.", payload));
        InvokeResult invokeResult = this.lambdaClient.invoke(invokeRequest);
        return invocationType.equals((Object)InvocationType.RequestResponse) ? Optional.of(new AlexaResponse(request, payload, new String(invokeResult.getPayload().array()))) : Optional.empty();
    }

    public static AlexaLambdaEndpointBuilder create(String lambdaFunctionName) {
        return new AlexaLambdaEndpointBuilder(lambdaFunctionName);
    }

    public static class AlexaLambdaEndpointBuilder {
        String lambdaFunctionName;
        AWSLambda lambdaClient;

        AlexaLambdaEndpointBuilder(String lambdaFunctionName) {
            this.lambdaFunctionName = lambdaFunctionName;
        }

        public AlexaLambdaEndpointBuilder withLambdaClient(AWSLambda lambdaClient) {
            this.lambdaClient = lambdaClient;
            return this;
        }

        public AlexaLambdaEndpoint build() {
            Validate.notBlank(this.lambdaFunctionName, "Lambda function name must not be empty.", new Object[0]);
            if (this.lambdaClient == null) {
                this.lambdaClient = new AWSLambdaClient();
            }
            return new AlexaLambdaEndpoint(this);
        }
    }
}

