/*
 * Decompiled with CFR 0.152.
 */
package io.klerch.alexa.test.client.endpoint;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.klerch.alexa.test.client.endpoint.AlexaApiEndpoint;
import java.util.HashMap;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpResponse;

public class AlexaInvocationApiEndpoint
extends AlexaApiEndpoint {
    @JsonIgnore
    private static final String DEFAULT_ENDPOINT_REGION = "NA";
    @JsonProperty
    private final SkillRequest skillRequest = new SkillRequest();
    @JsonProperty
    final String endpointRegion;

    AlexaInvocationApiEndpoint(AlexaInvocationApiEndpointBuilder builder) {
        super(builder);
        this.endpointRegion = builder.endpointRegion;
    }

    @Override
    public String getService() {
        return "invocations";
    }

    public static AlexaInvocationApiEndpointBuilder create(HashMap<Object, Object> endpointConfiguration) {
        return new AlexaInvocationApiEndpointBuilder(endpointConfiguration);
    }

    public static AlexaInvocationApiEndpointBuilder create(String skillId) {
        return new AlexaInvocationApiEndpointBuilder(skillId);
    }

    @Override
    HttpResponse fire(String payload) {
        try {
            String requestPayload = om.writeValueAsString(this).replace("\"" + "13a35817-70d3-4564-90c1-dee840cb0627" + "\"", payload);
            return super.fire(requestPayload);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not build request for Invocation API.", e);
        }
    }

    public static class AlexaInvocationApiEndpointBuilder
    extends AlexaApiEndpoint.AlexaApiEndpointBuilder<AlexaInvocationApiEndpoint> {
        String endpointRegion;

        AlexaInvocationApiEndpointBuilder(String skillId) {
            super(skillId);
        }

        AlexaInvocationApiEndpointBuilder(HashMap<Object, Object> endpointConfiguration) {
            super(endpointConfiguration);
            this.endpointRegion = endpointConfiguration.getOrDefault("region", AlexaInvocationApiEndpoint.DEFAULT_ENDPOINT_REGION).toString();
        }

        public AlexaApiEndpoint.AlexaApiEndpointBuilder withEndpointRegion(String endpointRegion) {
            this.endpointRegion = endpointRegion;
            return this;
        }

        @Override
        public AlexaInvocationApiEndpoint build() {
            this.preBuild();
            Validate.notBlank(this.endpointRegion, "Endpoint region in your Configuration section must not be empty.", new Object[0]);
            return new AlexaInvocationApiEndpoint(this);
        }
    }

    private class SkillRequest {
        @JsonProperty
        private final String body = "13a35817-70d3-4564-90c1-dee840cb0627";

        private SkillRequest() {
        }
    }
}

