/*
 * Decompiled with CFR 0.152.
 */
package io.klerch.alexa.test.client.endpoint;

import io.klerch.alexa.test.client.endpoint.AlexaEndpoint;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Optional;
import org.apache.log4j.Logger;

public class AlexaEndpointFactory {
    private static final Logger log = Logger.getLogger(AlexaEndpointFactory.class);

    public static AlexaEndpoint createEndpoint(HashMap<Object, Object> endpointConfiguration) {
        String endpointType = Optional.ofNullable(endpointConfiguration.get("type")).filter(o -> o instanceof String).map(Object::toString).orElseThrow(() -> new RuntimeException("Type in configuration must contain a valid string value."));
        String className = String.format("%1$s.Alexa%2$sEndpoint", AlexaEndpointFactory.class.getPackage().getName(), endpointType);
        try {
            Object endpointBuilder = Class.forName(className).getDeclaredMethod("create", HashMap.class).invoke(null, endpointConfiguration);
            return (AlexaEndpoint)endpointBuilder.getClass().getMethod("build", new Class[0]).invoke(endpointBuilder, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            String msg = String.format("Could not create endpoint of type %1$s. %2$s caused an error: %3$s", endpointType, className, e.getMessage());
            log.error(msg);
            throw new RuntimeException(msg, e);
        }
    }
}

