/*
 * Decompiled with CFR 0.152.
 */
package io.klerch.alexa.test.client.endpoint;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.klerch.alexa.test.client.endpoint.AlexaEndpoint;
import io.klerch.alexa.test.client.endpoint.AlexaInvocationApiEndpoint;
import io.klerch.alexa.test.request.AlexaRequest;
import io.klerch.alexa.test.response.AlexaResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;

public abstract class AlexaApiEndpoint
implements AlexaEndpoint {
    @JsonIgnore
    public static final String LWA_CLIENT_ID_PROPERTY = "lwaClientId";
    @JsonIgnore
    public static final String LWA_CLIENT_SECRET_PROPERTY = "lwaClientSecret";
    @JsonIgnore
    public static final String LWA_REFRESH_TOKEN_PROPERTY = "lwaRefreshToken";
    @JsonIgnore
    public static final String LWA_ACCESS_TOKEN_PROPERTY = "lwaAccessToken";
    @JsonIgnore
    private static final String IN_PROGRESS = "IN_PROGRESS";
    @JsonIgnore
    private final String lwaClientId;
    @JsonIgnore
    private final String lwaClientSecret;
    @JsonIgnore
    private final String lwaRefreshToken;
    @JsonIgnore
    private String lwaAccessToken;
    @JsonIgnore
    String id = "";
    @JsonIgnore
    static final ObjectMapper om = new ObjectMapper();
    @JsonIgnore
    static final Logger log = Logger.getLogger(AlexaInvocationApiEndpoint.class);
    @JsonIgnore
    final String skillId;

    AlexaApiEndpoint(AlexaApiEndpointBuilder builder) {
        this.skillId = builder.skillId;
        this.lwaClientId = Optional.ofNullable(builder.lwaClientId).filter(StringUtils::isNotBlank).orElse(System.getenv(LWA_CLIENT_ID_PROPERTY));
        Validate.notBlank(this.lwaClientId, "[ERROR] Missing the lwaClientId as an environment variable.", new Object[0]);
        this.lwaClientSecret = Optional.ofNullable(builder.lwaClientSecret).filter(StringUtils::isNotBlank).orElse(System.getenv(LWA_CLIENT_SECRET_PROPERTY));
        Validate.notBlank(this.lwaClientSecret, "[ERROR] Missing the lwaClientSecret as an environment variable.", new Object[0]);
        this.lwaRefreshToken = Optional.ofNullable(builder.lwaRefreshToken).filter(StringUtils::isNotBlank).orElse(System.getenv(LWA_REFRESH_TOKEN_PROPERTY));
        Validate.notBlank(this.lwaRefreshToken, "[ERROR] Missing the lwaRefreshToken as an environment variable.", new Object[0]);
        this.lwaAccessToken = System.getProperty(LWA_ACCESS_TOKEN_PROPERTY);
    }

    @JsonIgnore
    public abstract String getService();

    @Override
    public Optional<AlexaResponse> fire(AlexaRequest request, String payload) {
        JsonNode root = null;
        String statusCode = IN_PROGRESS;
        if (StringUtils.isBlank(this.lwaAccessToken)) {
            this.refreshToken();
        }
        while (IN_PROGRESS.equals(statusCode)) {
            String responsePayload;
            HttpResponse httpResponse = this.fire(payload);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                this.refreshToken();
                httpResponse = this.fire(payload);
            }
            this.id = "";
            Validate.inclusiveBetween(200, 399, Integer.valueOf(httpResponse.getStatusLine().getStatusCode()), httpResponse.getStatusLine().getReasonPhrase(), new Object[0]);
            HttpEntity responseEntity = httpResponse.getEntity();
            try {
                responsePayload = IOUtils.toString(responseEntity.getContent(), "UTF-8");
                log.debug(responsePayload);
                root = om.readTree(responsePayload);
            }
            catch (IOException e) {
                throw new RuntimeException("[ERROR] Invalid response from SMAPI. " + e.getMessage());
            }
            statusCode = root.get("status").textValue();
            Validate.isTrue(!StringUtils.equalsIgnoreCase("FAILED", statusCode), "SMAPI returned with an error. " + responsePayload, new Object[0]);
            if (!IN_PROGRESS.equals(statusCode)) continue;
            this.id = root.get("id").textValue();
            log.info("[INFO] Asynchronous processing in progress. Keep on polling for result of transaction with id " + this.id);
        }
        String endpoint = root.get("result").get("skillExecutionInfo").get("invocationRequest").get("endpoint").textValue();
        log.info("[INFO] Endpoint is " + endpoint);
        JsonNode responseBody = root.get("result").get("skillExecutionInfo").get("invocationResponse").get("body");
        Validate.notNull(responseBody, "[ERROR] Skill returned an invalid response", new Object[0]);
        try {
            return Optional.of(new AlexaResponse(request, payload, om.writeValueAsString(responseBody)));
        }
        catch (IOException e) {
            throw new RuntimeException("[ERROR] Could not parse skill response received from SMAPI. " + e.getMessage());
        }
    }

    HttpResponse fire(String payload) {
        try {
            return HttpClientBuilder.create().build().execute(this.getRequest(payload));
        }
        catch (IOException e) {
            throw new RuntimeException("[ERROR] Error received from SMAPI. " + e.getMessage());
        }
    }

    HttpUriRequest getRequest(String payload) {
        String url = "https://api.amazonalexa.com/v0/skills/" + this.skillId + "/" + this.getService() + (StringUtils.isNotBlank(this.id) ? "/" : "") + this.id;
        HttpRequestBase request = StringUtils.isNotBlank(this.id) ? new HttpGet(url) : new HttpPost(url);
        request.setHeader("Content-Type", "application/json");
        request.setHeader("Accept", "application/json");
        request.setHeader("Authorization", this.lwaAccessToken);
        if (request instanceof HttpPost) {
            ByteArrayEntity requestEntity = new ByteArrayEntity(payload.getBytes());
            ((HttpPost)request).setEntity(requestEntity);
        }
        return request;
    }

    public void refreshToken() {
        String url = "https://api.amazon.com/auth/o2/token";
        HttpPost httpPost = new HttpPost("https://api.amazon.com/auth/o2/token");
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Accept-Encoding", "application/json");
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("grant_type", "refresh_token"));
        nameValuePairs.add(new BasicNameValuePair("refresh_token", this.lwaRefreshToken));
        nameValuePairs.add(new BasicNameValuePair("client_id", this.lwaClientId));
        nameValuePairs.add(new BasicNameValuePair("client_secret", this.lwaClientSecret));
        try {
            httpPost.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)nameValuePairs));
            CloseableHttpResponse httpResponse = HttpClientBuilder.create().build().execute(httpPost);
            Validate.inclusiveBetween(200, 399, Integer.valueOf(httpResponse.getStatusLine().getStatusCode()), httpResponse.getStatusLine().getReasonPhrase(), new Object[0]);
            HttpEntity responseEntity = httpResponse.getEntity();
            String responsePayload = IOUtils.toString(responseEntity.getContent(), "UTF-8");
            this.cacheAccessToken(om.readTree(responsePayload));
        }
        catch (IOException e) {
            throw new RuntimeException("[ERROR] Error received from Login with Amazon on refreshing an access token. " + e.getMessage(), e);
        }
    }

    private void cacheAccessToken(JsonNode token) {
        this.lwaAccessToken = Optional.ofNullable(token.get("access_token")).orElseThrow(() -> new RuntimeException("Could not obtain access token from Amazon Login.")).textValue();
        System.setProperty(LWA_ACCESS_TOKEN_PROPERTY, this.lwaAccessToken);
    }

    public static abstract class AlexaApiEndpointBuilder<T extends AlexaApiEndpoint> {
        String skillId;
        String lwaClientId;
        String lwaClientSecret;
        String lwaRefreshToken;

        AlexaApiEndpointBuilder(String skillId) {
            this.skillId = skillId;
        }

        AlexaApiEndpointBuilder(HashMap<Object, Object> endpointConfiguration) {
            Validate.notEmpty(endpointConfiguration, "configuration section in your YAML file must not be empty. At least a type needs to be set.", new Object[0]);
            this.skillId = Optional.ofNullable(endpointConfiguration.get("skillId")).filter(o -> o instanceof String).map(Object::toString).filter(StringUtils::isNotBlank).orElse(System.getenv("skillId"));
            Optional.ofNullable(endpointConfiguration.get("lwa")).filter(o -> o instanceof HashMap).map(o -> (HashMap)o).ifPresent(yLwa -> {
                this.lwaClientId = Optional.ofNullable(yLwa.get("clientId")).map(Object::toString).orElse(null);
                this.lwaClientSecret = Optional.ofNullable(yLwa.get("clientSecret")).map(Object::toString).orElse(null);
                this.lwaRefreshToken = Optional.ofNullable(yLwa.get("refreshToken")).map(Object::toString).orElse(null);
            });
        }

        public AlexaApiEndpointBuilder withSkillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public AlexaApiEndpointBuilder withLwaClientId(String lwaClientId) {
            this.lwaClientId = lwaClientId;
            return this;
        }

        public AlexaApiEndpointBuilder withLwaClientSecret(String lwaClientSecret) {
            this.lwaClientSecret = lwaClientSecret;
            return this;
        }

        public AlexaApiEndpointBuilder withLwaRefreshToken(String lwaRefreshToken) {
            this.lwaRefreshToken = lwaRefreshToken;
            return this;
        }

        void preBuild() {
            Validate.notBlank(this.skillId, "[ERROR] SkillId must not be empty.", new Object[0]);
        }

        public abstract T build();
    }
}

