/*
 * Decompiled with CFR 0.152.
 */
package io.klerch.alexa.test.client;

import com.amazon.speech.json.SpeechletRequestEnvelope;
import com.amazon.speech.slu.Slot;
import com.amazon.speech.speechlet.Context;
import com.amazon.speech.speechlet.Session;
import com.amazon.speech.speechlet.SessionEndedRequest;
import com.amazon.speech.speechlet.interfaces.system.SystemState;
import io.klerch.alexa.test.client.AlexaActor;
import io.klerch.alexa.test.client.AlexaClient;
import io.klerch.alexa.test.client.endpoint.AlexaSimulationApiEndpoint;
import io.klerch.alexa.test.request.AlexaIntentRequest;
import io.klerch.alexa.test.request.AlexaLaunchRequest;
import io.klerch.alexa.test.request.AlexaRequest;
import io.klerch.alexa.test.request.AlexaSessionEndedRequest;
import io.klerch.alexa.test.request.AlexaSessionStartedRequest;
import io.klerch.alexa.test.request.AlexaUtteranceRequest;
import io.klerch.alexa.test.response.AlexaResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.log4j.Logger;

public class AlexaSession
extends AlexaActor {
    private static final Logger log = Logger.getLogger(AlexaClient.class);
    final Session session;
    boolean sessionClosed = false;

    public static String generateSessionId() {
        return String.format("SessionId.%s", UUID.randomUUID());
    }

    public AlexaSession(AlexaClient client, Session session) {
        super(client);
        this.session = session;
        this.getClient().getDebugFlagSessionAttributeName().ifPresent(name -> this.session.getAttributes().putIfAbsent((String)name, true));
    }

    public AlexaSession(AlexaClient client) {
        this(client, Session.builder().withApplication(client.getApplication()).withUser(client.getUser()).withIsNew(false).withSessionId(AlexaSession.generateSessionId()).withAttributes(new LinkedHashMap<String, Object>()).build());
        log.info(String.format("\n[START] session start request with sessionId '%s' ...", this.session.getSessionId()));
        client.fire(new AlexaSessionStartedRequest(this));
        log.info("[DONE] session start request.");
    }

    private Session getSessionWithIsNew() {
        return Session.builder().withApplication(this.session.getApplication()).withUser(this.session.getUser()).withIsNew(true).withSessionId(this.session.getSessionId()).withAttributes(this.session.getAttributes()).build();
    }

    private void applySessionAttributes(Map<String, Object> attributes) {
        this.session.getAttributes().clear();
        if (attributes != null) {
            attributes.forEach(this.session::setAttribute);
            this.getClient().getDebugFlagSessionAttributeName().ifPresent(name -> attributes.putIfAbsent((String)name, true));
        }
    }

    @Override
    public SpeechletRequestEnvelope envelope(AlexaRequest request) {
        SystemState systemState = SystemState.builder().withUser(this.session.getUser()).withDevice(this.client.device).withApiEndpoint(this.client.apiEndpoint).withApplication(this.session.getApplication()).build();
        Context context = Context.builder().addState(systemState).build();
        Validate.isTrue(!this.sessionClosed || AlexaSessionEndedRequest.class.isInstance(request) || AlexaLaunchRequest.class.isInstance(request), "Session already closed and not ready for another request.", new Object[0]);
        return SpeechletRequestEnvelope.builder().withRequest(request.getSpeechletRequest()).withSession(request instanceof AlexaSessionStartedRequest ? this.getSessionWithIsNew() : this.session).withVersion("1.0").withContext(context).build();
    }

    @Override
    public void exploitResponse(AlexaResponse response) {
        if (!response.isEmpty() && response.getResponseEnvelope() != null && response.getResponseEnvelope().getResponse() != null) {
            this.sessionClosed = response.getResponseEnvelope().getResponse().getNullableShouldEndSession();
            this.applySessionAttributes(response.getResponseEnvelope().getSessionAttributes());
        }
    }

    public AlexaResponse intent(String intentName) {
        return this.intent(new AlexaIntentRequest(this, intentName));
    }

    public AlexaResponse intent(String intentName, String slotName, Object slotValue) {
        return this.intent(new AlexaIntentRequest(this, intentName).withSlot(slotName, slotValue));
    }

    public AlexaResponse intent(String intentName, Map<String, Object> slots) {
        HashMap<String, Slot> slots2 = new HashMap<String, Slot>();
        slots.forEach((k, v) -> slots2.putIfAbsent((String)k, v instanceof Slot ? (Slot)v : Slot.builder().withName((String)k).withValue(v.toString()).build()));
        return this.intent(new AlexaIntentRequest(this, intentName).withSlots(slots2));
    }

    public AlexaResponse intent(String intentName, List<Slot> slots) {
        return this.intent(new AlexaIntentRequest(this, intentName).withSlots(slots));
    }

    private AlexaResponse intent(AlexaIntentRequest request) {
        log.info(String.format("\n[START] intent request '%1$s' %2$s ...", request.getIntentName(), request.getSlotSummary()));
        AlexaResponse response = this.client.fire(request).orElseThrow(() -> new RuntimeException("[ERROR] intent request did not receive a response."));
        log.info(String.format("[DONE] intent request '%1$s' in %2$s ms.", request.getIntentName(), this.getClient().getLastExecutionMillis()));
        return response;
    }

    public AlexaResponse say(String utterance) {
        Validate.isTrue(this.getClient().endpoint instanceof AlexaSimulationApiEndpoint, "Utterance requests are only supported by SimulationApi-Endpoints.", new Object[0]);
        log.info(String.format("\n[START] utterance request '%s' ...", utterance));
        AlexaResponse response = this.client.fire(new AlexaUtteranceRequest(this), utterance).orElseThrow(() -> new RuntimeException("[ERROR] utterance request did not receive a response."));
        log.info(String.format("[DONE] utterance request '%1$s' in %2$s ms.", utterance, this.getClient().getLastExecutionMillis()));
        return response;
    }

    public AlexaResponse launch() {
        this.session.getAttributes().clear();
        log.info("\n[START] launch request ...");
        AlexaResponse response = this.client.fire(new AlexaLaunchRequest(this)).orElseThrow(() -> new RuntimeException("[ERROR] launch request did not receive a response."));
        log.info(String.format("[DONE] launch request in %1$s ms.", this.getClient().getLastExecutionMillis()));
        return response;
    }

    public AlexaResponse repeat() {
        return this.intent("AMAZON.RepeatIntent");
    }

    public AlexaResponse yes() {
        return this.intent("AMAZON.YesIntent");
    }

    public AlexaResponse no() {
        return this.intent("AMAZON.NoIntent");
    }

    public AlexaResponse cancel() {
        return this.intent("AMAZON.CancelIntent");
    }

    public AlexaResponse stop() {
        return this.intent("AMAZON.StopIntent");
    }

    public AlexaResponse startOver() {
        return this.intent("AMAZON.StartOverIntent");
    }

    public AlexaResponse next() {
        return this.intent("AMAZON.NextIntent");
    }

    public AlexaResponse previous() {
        return this.intent("AMAZON.PreviousIntent");
    }

    public AlexaResponse pause() {
        return this.intent("AMAZON.PauseIntent");
    }

    public AlexaResponse resume() {
        return this.intent("AMAZON.ResumeIntent");
    }

    public AlexaResponse shuffleOn() {
        return this.intent("AMAZON.ShuffleOnIntent");
    }

    public AlexaResponse shuffleOff() {
        return this.intent("AMAZON.ShuffleOffIntent");
    }

    public AlexaResponse loopOn() {
        return this.intent("AMAZON.LoopOnIntent");
    }

    public AlexaResponse loopOff() {
        return this.intent("AMAZON.LoopOffIntent");
    }

    public AlexaResponse help() {
        return this.intent("AMAZON.HelpIntent");
    }

    public AlexaSession delay(long millis) {
        log.info(String.format("\n[START] wait for %s ms.", millis));
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            String msg = String.format("Error while waiting for %1$s ms caused by %2$s", millis, e.getMessage());
            log.error(String.format("[ERROR] %s", msg));
            throw new RuntimeException(msg, e);
        }
        log.info(String.format("[DONE] wait for %s ms.", millis));
        return this;
    }

    public void endSession() {
        this.endSession(SessionEndedRequest.Reason.USER_INITIATED);
    }

    public void endSession(SessionEndedRequest.Reason reason) {
        log.info(String.format("\n[START] request session end with reason '%s'.", reason.name()));
        this.client.fire(new AlexaSessionEndedRequest(this, reason));
        log.info(String.format("[DONE] request session end with reason '%s'.", reason.name()));
    }

    void executeSession(Object yLaunch) {
        if (yLaunch instanceof Optional) {
            ((Optional)yLaunch).ifPresent(launch -> this.executeAction((ArrayList)launch));
        } else if (yLaunch instanceof ArrayList) {
            this.executeAction((ArrayList)yLaunch);
        } else {
            log.warn("Launch node is of unexpected type.");
        }
    }

    void executeAction(ArrayList assets) {
        ArrayList assertions = new ArrayList();
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, ArrayList> conditions = new HashMap<String, ArrayList>();
        ArrayList followUps = new ArrayList();
        AtomicReference intentName = new AtomicReference();
        AtomicReference utterance = new AtomicReference();
        assets.forEach(asset -> {
            if (asset instanceof String) {
                assertions.add(asset.toString());
            } else if (asset instanceof Map) {
                Map kv = (Map)asset;
                if (kv.values().stream().allMatch(v -> v instanceof String)) {
                    kv.forEach((k, v) -> {
                        if (StringUtils.equalsIgnoreCase(k.toString(), "intent")) {
                            intentName.set(v.toString());
                        } else if (StringUtils.equalsIgnoreCase(k.toString(), "utterance")) {
                            utterance.set(v.toString());
                        } else {
                            String value = v.toString();
                            if (value.startsWith("$")) {
                                String resolvedValue = Optional.ofNullable(this.client.getLastResponse()).map(lr -> lr.get(value).orElse(null)).filter(Objects::nonNull).orElseThrow(() -> new RuntimeException(value + " could not be resolved for slot " + k));
                                params.putIfAbsent(k.toString(), resolvedValue);
                            } else {
                                params.putIfAbsent(k.toString(), value);
                            }
                        }
                    });
                } else if (kv.values().stream().allMatch(v -> v instanceof ArrayList)) {
                    kv.forEach((k, v) -> conditions.putIfAbsent(k.toString(), (ArrayList)v));
                }
            } else if (asset instanceof ArrayList) {
                followUps.add((ArrayList)asset);
            }
        });
        AlexaResponse response = StringUtils.isNotBlank((CharSequence)intentName.get()) ? this.intent((String)intentName.get(), params) : (StringUtils.isNotBlank((CharSequence)utterance.get()) ? this.say((String)utterance.get()) : this.launch());
        assertions.forEach(response::assertThat);
        conditions.forEach((condition, followUp) -> {
            if (response.is((String)condition)) {
                this.executeAction((ArrayList)followUp);
            }
        });
        followUps.forEach(this::executeAction);
    }
}

