/*
 * Decompiled with CFR 0.152.
 */
package io.klerch.alexa.test.client;

import com.amazon.speech.json.SpeechletRequestEnvelope;
import com.amazon.speech.json.SpeechletRequestModule;
import com.amazon.speech.speechlet.Application;
import com.amazon.speech.speechlet.Device;
import com.amazon.speech.speechlet.Interface;
import com.amazon.speech.speechlet.SupportedInterfaces;
import com.amazon.speech.speechlet.User;
import com.amazon.speech.speechlet.interfaces.audioplayer.AudioPlayerInterface;
import com.amazon.speech.speechlet.interfaces.display.DisplayInterface;
import com.amazonaws.util.StringUtils;
import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlReader;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.klerch.alexa.test.client.AlexaSession;
import io.klerch.alexa.test.client.endpoint.AlexaEndpoint;
import io.klerch.alexa.test.client.endpoint.AlexaEndpointFactory;
import io.klerch.alexa.test.request.AlexaRequest;
import io.klerch.alexa.test.response.AlexaResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.log4j.Logger;

public class AlexaClient {
    private static final Logger log = Logger.getLogger(AlexaClient.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    public static final String VERSION = "1.0";
    final AlexaEndpoint endpoint;
    private AlexaResponse lastResponse;
    final String apiEndpoint;
    private final long millisFromCurrentDate;
    private long lastExecutionTimeMillis;
    private final Locale locale;
    final Device device;
    private final Application application;
    private final User user;
    private final Optional<String> debugFlagSessionAttributeName;
    private final Object yLaunch;
    private static Map<API_ENDPOINT, String> apiEndpoints = new HashMap<API_ENDPOINT, String>();

    AlexaClient(AlexaClientBuilder builder) {
        this.millisFromCurrentDate = builder.timestamp.getTime() - new Date().getTime();
        this.locale = builder.locale;
        this.apiEndpoint = apiEndpoints.getOrDefault((Object)builder.apiEndpoint, apiEndpoints.get((Object)API_ENDPOINT.NA));
        this.application = new Application(builder.applicationId);
        this.user = User.builder().withUserId(builder.uid).withAccessToken(builder.accessToken).build();
        this.device = builder.device;
        this.debugFlagSessionAttributeName = StringUtils.isNullOrEmpty(builder.debugFlagSessionAttributeName) ? Optional.empty() : Optional.of(builder.debugFlagSessionAttributeName);
        this.endpoint = builder.endpoint;
        this.yLaunch = builder.yLaunch;
    }

    public AlexaResponse getLastResponse() {
        return this.lastResponse;
    }

    public long getLastExecutionMillis() {
        return this.lastExecutionTimeMillis;
    }

    public AlexaEndpoint getEndpoint() {
        return this.endpoint;
    }

    public static String generateUserId() {
        return String.format("amzn1.ask.account.%s", RandomStringUtils.randomAlphanumeric(207).toUpperCase());
    }

    public static String generateApplicationId() {
        return String.format("amzn1.ask.skill.%s", UUID.randomUUID());
    }

    public Date getCurrentTimestamp() {
        return new Date(new Date().getTime() + this.millisFromCurrentDate);
    }

    public Application getApplication() {
        return this.application;
    }

    public User getUser() {
        return this.user;
    }

    public Optional<String> getDebugFlagSessionAttributeName() {
        return this.debugFlagSessionAttributeName;
    }

    Optional<AlexaResponse> fire(AlexaRequest request) {
        SpeechletRequestEnvelope envelope = request.getSession().envelope(request);
        String payload = null;
        try {
            payload = mapper.writeValueAsString(envelope);
        }
        catch (JsonProcessingException e) {
            String msg = String.format("Invalid request format. %s", e.getMessage());
            log.error(String.format("\u2192 [ERROR] %s", msg));
            throw new RuntimeException(msg, e);
        }
        return this.fire(request, payload);
    }

    Optional<AlexaResponse> fire(AlexaRequest request, String payload) {
        Validate.notBlank(payload, "[ERROR] Invalid speechlet request contents. Must not be null or empty.", new Object[0]);
        long startTimestamp = System.currentTimeMillis();
        Optional<AlexaResponse> response = this.endpoint.fire(request, payload);
        this.lastExecutionTimeMillis = System.currentTimeMillis() - startTimestamp;
        response.ifPresent(r -> {
            request.getSession().exploitResponse((AlexaResponse)r);
            this.lastResponse = r;
        });
        return response;
    }

    public static AlexaClientBuilder create(AlexaEndpoint endpoint) {
        return new AlexaClientBuilder(endpoint);
    }

    public static AlexaClientBuilder create(AlexaEndpoint endpoint, String applicationId) {
        return AlexaClient.create(endpoint).withApplicationId(applicationId);
    }

    public static AlexaClientBuilder create(InputStream scriptInputStream) throws IOException {
        YamlReader yamlReader = new YamlReader(IOUtils.toString(scriptInputStream));
        return new AlexaClientBuilder(yamlReader);
    }

    public static AlexaClientBuilder create(String filePath) throws IOException {
        return AlexaClient.create(new FileInputStream(filePath));
    }

    public static AlexaClientBuilder create(File file) throws IOException {
        return AlexaClient.create(new FileInputStream(file));
    }

    public AlexaSession startSession() {
        return new AlexaSession(this);
    }

    public void startScript() {
        Validate.notNull(this.yLaunch, "[ERROR] Could not find Launch node. Add this node to the top level of your YAML script and use it as an entry point for your conversation path.", new Object[0]);
        this.startSession().executeSession(this.yLaunch);
    }

    public Locale getLocale() {
        return this.locale;
    }

    static {
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.enable(SerializationFeature.WRITE_NULL_MAP_VALUES);
        mapper.registerModule(new SpeechletRequestModule());
        apiEndpoints.putIfAbsent(API_ENDPOINT.NA, "https://api.amazonalexa.com/");
        apiEndpoints.putIfAbsent(API_ENDPOINT.EU, "https://api.eu.amazonalexa.com/");
    }

    public static class AlexaClientBuilder {
        AlexaEndpoint endpoint;
        Object yLaunch;
        String applicationId;
        API_ENDPOINT apiEndpoint;
        Locale locale;
        private String uid;
        private String accessToken;
        String debugFlagSessionAttributeName;
        String deviceId;
        Device device;
        List<Interface> interfaces = new ArrayList<Interface>();
        Date timestamp;

        AlexaClientBuilder(AlexaEndpoint endpoint) {
            this.endpoint = endpoint;
        }

        AlexaClientBuilder(YamlReader root) {
            HashMap yRoot = null;
            try {
                yRoot = (HashMap)root.read();
            }
            catch (YamlException e) {
                log.error("[ERROR] Could not read YAML script file", e);
            }
            HashMap yConfig = Optional.ofNullable(yRoot.get("configuration")).filter(o -> o instanceof HashMap).map(o -> (HashMap)o).orElseThrow(() -> new RuntimeException("configuration node is missing or empty."));
            HashMap yEndpoint = Optional.ofNullable(yConfig.get("endpoint")).filter(o -> o instanceof HashMap).map(o -> (HashMap)o).orElseThrow(() -> new RuntimeException("endpoint node is missing or empty."));
            this.endpoint = AlexaEndpointFactory.createEndpoint(yEndpoint);
            this.applicationId = Optional.ofNullable(yEndpoint.get("skillId")).filter(o -> o instanceof String).map(Object::toString).orElse(System.getenv("skillId"));
            this.locale = Locale.forLanguageTag(Optional.ofNullable(yEndpoint.get("locale")).filter(o -> o instanceof String).map(Object::toString).orElse("en-US"));
            this.apiEndpoint = Optional.ofNullable(yEndpoint.get("region")).filter(o -> o instanceof String).map(o -> API_ENDPOINT.valueOf(o.toString())).orElse(API_ENDPOINT.NA);
            this.debugFlagSessionAttributeName = Optional.ofNullable(yConfig.get("debugFlagSessionAttributeName")).filter(o -> o instanceof String).map(Object::toString).orElse(null);
            Optional.ofNullable(yConfig.get("device")).filter(o -> o instanceof HashMap).map(o -> (HashMap)o).ifPresent(yDevice -> {
                this.deviceId = Optional.ofNullable(yDevice.get("id")).map(Object::toString).orElse(System.getenv("skillDeviceId"));
                Optional.ofNullable(yDevice.get("supportedInterfaces")).filter(o -> o instanceof ArrayList).map(o -> (ArrayList)o).ifPresent(yInterfaces -> yInterfaces.forEach(yInterface -> {
                    String interfaceName = yInterface.toString();
                    if ("Display".equals(interfaceName)) {
                        this.withSupportedInterface(DisplayInterface.builder().build());
                    }
                    if ("AudioPlayer".equals(interfaceName)) {
                        this.withSupportedInterface(AudioPlayerInterface.builder().build());
                    }
                }));
            });
            Optional.ofNullable(yConfig.get("user")).filter(o -> o instanceof HashMap).map(o -> (HashMap)o).ifPresent(yUser -> {
                this.uid = Optional.ofNullable(yUser.get("id")).map(Object::toString).orElse(System.getenv("skillUserId"));
                this.accessToken = Optional.ofNullable(yUser.get("accessToken")).map(Object::toString).orElse(System.getenv("skillAccessToken"));
            });
            this.yLaunch = Optional.ofNullable(yRoot.get("Launch")).orElseThrow(() -> new RuntimeException("There's no 'Launch'-node provided in the YAML script. Create a top-level node named 'Launch' as it is the entry point for the conversation you'd like to simulate."));
        }

        public AlexaClientBuilder withEndpoint(AlexaEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public AlexaClientBuilder withApiEndpoint(API_ENDPOINT apiEndpoint) {
            this.apiEndpoint = apiEndpoint;
            return this;
        }

        public AlexaClientBuilder withApplicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public AlexaClientBuilder withLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public AlexaClientBuilder withDeviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public AlexaClientBuilder withDeviceIdRandomized() {
            this.deviceId = UUID.randomUUID().toString();
            return this;
        }

        public AlexaClientBuilder withSupportedInterface(Interface supportedInterface) {
            if (!this.interfaces.contains(supportedInterface)) {
                this.interfaces.add(supportedInterface);
            }
            return this;
        }

        public AlexaClientBuilder withDevice(Device device) {
            this.device = device;
            return this;
        }

        public AlexaClientBuilder withLocale(String languageTag) {
            if (!StringUtils.isNullOrEmpty(languageTag)) {
                this.locale = Locale.forLanguageTag(languageTag);
            }
            return this;
        }

        public AlexaClientBuilder withUserId(String uid) {
            this.uid = uid;
            return this;
        }

        public AlexaClientBuilder withAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public AlexaClientBuilder withTimestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public AlexaClientBuilder withDebugFlagSessionAttribute(String debugFlagSessionAttributeName) {
            this.debugFlagSessionAttributeName = debugFlagSessionAttributeName;
            return this;
        }

        void preBuild() {
            Validate.notNull(this.endpoint, "Endpoint must not be null.", new Object[0]);
            if (StringUtils.isNullOrEmpty(this.applicationId)) {
                this.applicationId = AlexaClient.generateApplicationId();
            }
            if (this.locale == null) {
                this.locale = Locale.US;
            }
            if (StringUtils.isNullOrEmpty(this.uid)) {
                this.uid = AlexaClient.generateUserId();
            }
            if (this.timestamp == null) {
                this.timestamp = new Date();
            }
            if (this.device == null) {
                SupportedInterfaces supportedInterfaces = null;
                if (!this.interfaces.isEmpty()) {
                    SupportedInterfaces.Builder supportedInterfacesBuilder = SupportedInterfaces.builder();
                    this.interfaces.forEach(supportedInterfacesBuilder::addSupportedInterface);
                    supportedInterfaces = supportedInterfacesBuilder.build();
                } else {
                    supportedInterfaces = SupportedInterfaces.builder().build();
                }
                this.device = Device.builder().withSupportedInterfaces(supportedInterfaces).withDeviceId(this.deviceId).build();
            }
        }

        public AlexaClient build() {
            this.preBuild();
            return new AlexaClient(this);
        }
    }

    public static enum API_ENDPOINT {
        NA,
        EU;

    }
}

