/*
 * Decompiled with CFR 0.152.
 */
package io.klerch.alexa.test;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.util.IOUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.klerch.alexa.test.client.AlexaClient;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.log4j.Logger;

public class Lambda
implements RequestStreamHandler {
    private static final String S3_BUCKET_PROPERTY = "s3Bucket";
    private static final String S3_KEY_PROPERTY = "s3Key";
    private static final String S3_REGION_PROPERTY = "s3Region";
    private static final Logger log = Logger.getLogger(Lambda.class);
    private final ObjectMapper om = new ObjectMapper();

    @Override
    public void handleRequest(InputStream input, OutputStream output, Context context) throws IOException {
        String inputS = IOUtils.toString(Optional.ofNullable(input).orElse(new ByteArrayInputStream("{}".getBytes())));
        JsonNode root = this.om.readTree(inputS);
        String bucket = Optional.ofNullable(root.get(S3_BUCKET_PROPERTY)).map(JsonNode::textValue).filter(StringUtils::isNotBlank).orElse(System.getenv(S3_BUCKET_PROPERTY));
        Validate.notBlank(bucket, "s3Bucket hasn't been set in the request payload nor as an environment variable.", new Object[0]);
        String key = Optional.ofNullable(root.get(S3_KEY_PROPERTY)).map(JsonNode::textValue).filter(StringUtils::isNotBlank).orElse(System.getenv(S3_KEY_PROPERTY));
        String region = Optional.ofNullable(root.get(S3_REGION_PROPERTY)).map(JsonNode::textValue).filter(StringUtils::isNotBlank).orElse(System.getenv(S3_REGION_PROPERTY));
        AmazonS3 s3client = StringUtils.isNotBlank(region) ? (AmazonS3)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(region)).build() : AmazonS3ClientBuilder.defaultClient();
        ListObjectsRequest listRequest = new ListObjectsRequest().withBucketName(bucket).withPrefix(Optional.ofNullable(key).map(k -> k + (k.endsWith("/") ? "" : "/")).orElse(""));
        log.info("[INFO] Reading out *.yml conversation script files in folder '" + listRequest.getPrefix() + "' in bucket '" + listRequest.getBucketName() + "'");
        List conversationScripts = s3client.listObjects(listRequest).getObjectSummaries().stream().filter(os -> os.getKey().toLowerCase().endsWith(".yml")).collect(Collectors.toList());
        log.info("[INFO] Found " + conversationScripts.size() + " conversation script files in bucket '" + bucket + "'");
        for (S3ObjectSummary conversationScript : conversationScripts) {
            log.info("[INFO] Load conversation script file " + conversationScript.getKey() + " from S3 bucket " + bucket);
            AlexaClient.create(s3client.getObject(bucket, conversationScript.getKey()).getObjectContent()).build().startScript();
        }
        output.write("{ \"OK\" }".getBytes());
    }
}

