/*
 * Decompiled with CFR 0.152.
 */
package io.klerch.alexa.test;

import io.klerch.alexa.test.client.AlexaClient;
import java.io.IOException;
import org.apache.commons.lang3.Validate;
import org.apache.log4j.Logger;

public class Console {
    private static final String errNoFilePath = "[ERROR] Missing file path. Use -f followed by the file path of your YAML script file.";
    private static final Logger log = Logger.getLogger(Console.class);

    public static void main(String[] args) {
        Console.readFile(args);
    }

    private static void readFile(String[] args) {
        Validate.notEmpty(args, errNoFilePath, new Object[0]);
        Validate.isTrue(args.length > 1, errNoFilePath, new Object[0]);
        Validate.isTrue(args[0].equalsIgnoreCase("-f") || args[0].equalsIgnoreCase("-file"), "Missing -f or -file parameter. Use -f followed by the file path of your YAML script file.", new Object[0]);
        try {
            AlexaClient.create(args[1]).build().startScript();
        }
        catch (IOException e) {
            log.error(e);
            e.printStackTrace();
        }
    }
}

