/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.log4j;

import com.amazonaws.services.lambda.runtime.LambdaLogger;
import com.amazonaws.services.lambda.runtime.LambdaRuntime;
import com.amazonaws.services.lambda.runtime.LambdaRuntimeInternal;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class LambdaAppender
extends AppenderSkeleton {
    LambdaLogger logger = LambdaRuntime.getLogger();

    public LambdaAppender() {
        LambdaRuntimeInternal.setUseLog4jAppender((boolean)true);
    }

    protected void append(LoggingEvent event) {
        if (this.layout == null) {
            this.logger.log(event.getLevel() + " " + event.getMessage());
            return;
        }
        this.logger.log(this.layout.format(event));
        if (this.layout.ignoresThrowable()) {
            StringBuilder traceString = new StringBuilder();
            String[] s = event.getThrowableStrRep();
            if (s != null) {
                int len = s.length;
                for (int i = 0; i < len; ++i) {
                    traceString.append(s[i]);
                    traceString.append(Layout.LINE_SEP);
                }
            }
            this.logger.log(traceString.toString());
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }
}

