/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.verifier;

import com.amazon.speech.speechlet.Session;
import com.amazon.speech.speechlet.SpeechletRequest;
import com.amazon.speech.speechlet.verifier.SpeechletRequestVerifier;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampSpeechletRequestVerifier
implements SpeechletRequestVerifier {
    private static final Logger log = LoggerFactory.getLogger(TimestampSpeechletRequestVerifier.class);
    private final long toleranceInMilliseconds;

    public TimestampSpeechletRequestVerifier(long tolerance, TimeUnit unit) {
        if (tolerance < 0L) {
            throw new IllegalArgumentException("A negative tolerance is not supported");
        }
        this.toleranceInMilliseconds = unit.toMillis(tolerance);
    }

    @Override
    public boolean verify(SpeechletRequest request, Session session) {
        boolean withinTolerance;
        if (request == null || request.getTimestamp() == null) {
            return false;
        }
        long delta = Math.abs(System.currentTimeMillis() - request.getTimestamp().getTime());
        boolean bl = withinTolerance = delta <= this.toleranceInMilliseconds;
        if (!withinTolerance) {
            log.warn("Request with id {} and timestamp {} failed timestamp validation with a delta {}", request.getRequestId(), request.getTimestamp().getTime(), delta);
        }
        return withinTolerance;
    }
}

