/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.verifier;

import com.amazon.speech.json.SpeechletResponseEnvelope;
import com.amazon.speech.speechlet.Session;
import com.amazon.speech.speechlet.verifier.SpeechletResponseVerifier;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseSizeSpeechletResponseVerifier
implements SpeechletResponseVerifier {
    private static final Logger log = LoggerFactory.getLogger(ResponseSizeSpeechletResponseVerifier.class);
    private static final int MAX_RESPONSE_SIZE = 24576;

    @Override
    public boolean verify(SpeechletResponseEnvelope responseEnvelope, Session session) {
        if (responseEnvelope == null) {
            return false;
        }
        byte[] jsonBytes = null;
        try {
            jsonBytes = responseEnvelope.toJsonBytes();
        }
        catch (IOException e) {
            log.warn("Caught exception while trying to serialize ResponseEnvelope", e);
            return false;
        }
        int responseSize = jsonBytes.length;
        if (responseSize > 24576) {
            log.warn("Speechlet response with size of {} bytes exceeds the maximum allowed size of {} bytes and will be rejected by the Alexa service", (Object)responseSize, (Object)24576);
        }
        return true;
    }
}

