/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.verifier;

import com.amazon.speech.json.SpeechletResponseEnvelope;
import com.amazon.speech.speechlet.Session;
import com.amazon.speech.speechlet.verifier.SpeechletResponseVerifier;
import com.amazon.speech.ui.OutputSpeech;
import com.amazon.speech.ui.PlainTextOutputSpeech;
import com.amazon.speech.ui.SsmlOutputSpeech;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputSpeechSpeechletResponseVerifier
implements SpeechletResponseVerifier {
    private static final Logger log = LoggerFactory.getLogger(OutputSpeechSpeechletResponseVerifier.class);
    private static final int MAX_SPEECH_SIZE = 8000;

    @Override
    public boolean verify(SpeechletResponseEnvelope responseEnvelope, Session session) {
        if (responseEnvelope == null || responseEnvelope.getResponse() == null) {
            return true;
        }
        OutputSpeech outputSpeech = responseEnvelope.getResponse().getOutputSpeech();
        String speechContent = null;
        if (outputSpeech instanceof PlainTextOutputSpeech) {
            speechContent = ((PlainTextOutputSpeech)outputSpeech).getText();
        } else if (outputSpeech instanceof SsmlOutputSpeech) {
            speechContent = ((SsmlOutputSpeech)outputSpeech).getSsml();
        }
        int speechContentLength = StringUtils.length(speechContent);
        if (speechContentLength > 8000) {
            log.warn("OutputSpeech with size {} exceeds the maximum allowed size of {} and will be rejected by the Alexa service", (Object)speechContentLength, (Object)8000);
        }
        return true;
    }
}

