/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.servlet;

import com.amazon.speech.speechlet.SpeechletRequestHandler;
import com.amazon.speech.speechlet.verifier.ApplicationIdSpeechletRequestEnvelopeVerifier;
import com.amazon.speech.speechlet.verifier.SpeechletRequestEnvelopeVerifier;
import com.amazon.speech.speechlet.verifier.SpeechletRequestVerifierWrapper;
import com.amazon.speech.speechlet.verifier.TimestampSpeechletRequestVerifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletSpeechletRequestHandler
extends SpeechletRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(ServletSpeechletRequestHandler.class);

    public ServletSpeechletRequestHandler() {
        super(ServletSpeechletRequestHandler.requestVerifiers());
    }

    private static List<SpeechletRequestEnvelopeVerifier> requestVerifiers() {
        ArrayList<SpeechletRequestEnvelopeVerifier> requestVerifiers = new ArrayList<SpeechletRequestEnvelopeVerifier>();
        requestVerifiers.add(ServletSpeechletRequestHandler.getApplicationIdVerifier());
        TimestampSpeechletRequestVerifier timestampVerifier = ServletSpeechletRequestHandler.getTimestampVerifier();
        if (timestampVerifier != null) {
            requestVerifiers.add(new SpeechletRequestVerifierWrapper(timestampVerifier));
        }
        return requestVerifiers;
    }

    private static TimestampSpeechletRequestVerifier getTimestampVerifier() {
        String timestampToleranceAsString = System.getProperty("com.amazon.speech.speechlet.servlet.timestampTolerance");
        if (!StringUtils.isBlank(timestampToleranceAsString)) {
            try {
                long timestampTolerance = Long.parseLong(timestampToleranceAsString);
                return new TimestampSpeechletRequestVerifier(timestampTolerance, TimeUnit.SECONDS);
            }
            catch (NumberFormatException ex) {
                log.warn("The configured timestamp tolerance {} is invalid, disabling timestamp verification", (Object)timestampToleranceAsString);
            }
        } else {
            log.warn("No timestamp tolerance has been configured, disabling timestamp verification");
        }
        return null;
    }

    private static ApplicationIdSpeechletRequestEnvelopeVerifier getApplicationIdVerifier() {
        Set<String> supportedApplicationIds = Collections.emptySet();
        String commaDelimitedListOfSupportedApplicationIds = System.getProperty("com.amazon.speech.speechlet.servlet.supportedApplicationIds");
        if (!StringUtils.isBlank(commaDelimitedListOfSupportedApplicationIds)) {
            supportedApplicationIds = new HashSet<String>(Arrays.asList(commaDelimitedListOfSupportedApplicationIds.split(",")));
        }
        return new ApplicationIdSpeechletRequestEnvelopeVerifier(supportedApplicationIds);
    }
}

