/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.services.householdlist;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;

public class ListItemBody {
    private final String listId;
    private final List<String> listItemIds;

    public static Builder builder() {
        return new Builder();
    }

    private ListItemBody(Builder builder) {
        this.listId = builder.listId;
        this.listItemIds = Collections.unmodifiableList(builder.listItemIds);
    }

    private ListItemBody(@JsonProperty(value="listId") String listId, @JsonProperty(value="listItemIds") List<String> listItemIds) {
        this.listId = listId;
        this.listItemIds = listItemIds != null ? Collections.unmodifiableList(listItemIds) : Collections.emptyList();
    }

    public String getListId() {
        return this.listId;
    }

    public List<String> getListItemIds() {
        return this.listItemIds;
    }

    public static final class Builder {
        private String listId;
        private List<String> listItemIds;

        public Builder withListId(String listId) {
            this.listId = listId;
            return this;
        }

        public Builder withListItemIds(List<String> listItemIds) {
            this.listItemIds = listItemIds;
            return this;
        }

        public ListItemBody build() {
            return new ListItemBody(this);
        }
    }
}

