/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.services;

import com.amazon.speech.speechlet.services.ApiClient;
import com.amazon.speech.speechlet.services.ApiClientResponse;
import com.amazon.speech.speechlet.services.ListService;
import com.amazon.speech.speechlet.services.ServiceException;
import com.amazon.speech.speechlet.services.householdlist.client.AlexaList;
import com.amazon.speech.speechlet.services.householdlist.client.AlexaListItem;
import com.amazon.speech.speechlet.services.householdlist.client.AlexaListMetadata;
import com.amazon.speech.speechlet.services.householdlist.client.AlexaListsMetadata;
import com.amazon.speech.speechlet.services.householdlist.client.CreateListItemRequest;
import com.amazon.speech.speechlet.services.householdlist.client.CreateListRequest;
import com.amazon.speech.speechlet.services.householdlist.client.ListState;
import com.amazon.speech.speechlet.services.householdlist.client.UpdateListItemRequest;
import com.amazon.speech.speechlet.services.householdlist.client.UpdateListRequest;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ListServiceClient
implements ListService {
    static final String API_ENDPOINT = "https://api.amazonalexa.com";
    private final ObjectMapper mapper;
    private final ApiClient client;

    public ListServiceClient() {
        this(new ApiClient());
    }

    ListServiceClient(ApiClient client) {
        this.client = client;
        this.mapper = new ObjectMapper();
    }

    @Override
    public AlexaListsMetadata getListsMetadata(String token) throws ServiceException {
        String uri = "https://api.amazonalexa.com/v2/householdlists/";
        try {
            ApiClientResponse response = this.client.get(uri, this.getRequestHeaders(token));
            if (response.getResponseCode() >= 200 && response.getResponseCode() < 300) {
                return this.mapper.readValue(response.getResponseBody(), AlexaListsMetadata.class);
            }
            throw new ServiceException("Got a non-successful response for lists metadata query");
        }
        catch (IOException e) {
            throw new ServiceException("Encountered an IOException while attempting to retrieve lists metadata", e);
        }
    }

    @Override
    public AlexaList getList(String listId, ListState status, String token) throws ServiceException {
        String uri = API_ENDPOINT + String.format("/v2/householdlists/%s/%s", listId, status.toString());
        try {
            ApiClientResponse response = this.client.get(uri, this.getRequestHeaders(token));
            if (response.getResponseCode() >= 200 && response.getResponseCode() < 300) {
                return this.mapper.readValue(response.getResponseBody(), AlexaList.class);
            }
            throw new ServiceException("Got a non-successful response for list query");
        }
        catch (IOException e) {
            throw new ServiceException("Encountered an IOException while attempting to retrieve list", e);
        }
    }

    @Override
    public AlexaListMetadata createList(CreateListRequest request, String token) throws ServiceException {
        String uri = "https://api.amazonalexa.com/v2/householdlists/";
        try {
            ApiClientResponse response = this.client.post(uri, this.getRequestHeaders(token), this.mapper.writeValueAsString(request));
            if (response.getResponseCode() >= 200 && response.getResponseCode() < 300) {
                return this.mapper.readValue(response.getResponseBody(), AlexaListMetadata.class);
            }
            throw new ServiceException("Got a non-successful response for create list request");
        }
        catch (IOException e) {
            throw new ServiceException("Encountered an IOException while attempting to create list", e);
        }
    }

    @Override
    public AlexaListMetadata updateList(String listId, UpdateListRequest request, String token) throws ServiceException {
        String uri = "https://api.amazonalexa.com/v2/householdlists/" + listId;
        try {
            ApiClientResponse response = this.client.put(uri, this.getRequestHeaders(token), this.mapper.writeValueAsString(request));
            if (response.getResponseCode() >= 200 && response.getResponseCode() < 300) {
                return this.mapper.readValue(response.getResponseBody(), AlexaListMetadata.class);
            }
            throw new ServiceException("Got a non-successful response for update list request");
        }
        catch (IOException e) {
            throw new ServiceException("Encountered an IOException while attempting to update list", e);
        }
    }

    @Override
    public void deleteList(String listId, String token) throws ServiceException {
        String uri = API_ENDPOINT + String.format("/v2/householdlists/%s", listId);
        try {
            ApiClientResponse response = this.client.delete(uri, this.getRequestHeaders(token));
            if (response.getResponseCode() < 200 || response.getResponseCode() >= 300) {
                throw new ServiceException("Got a non-successful response for delete list request");
            }
        }
        catch (IOException e) {
            throw new ServiceException("Encountered an IOException while attempting to delete list", e);
        }
    }

    @Override
    public AlexaListItem getListItem(String listId, String itemId, String token) throws ServiceException {
        String uri = String.format("https://api.amazonalexa.com/v2/householdlists/%s/items/%s", listId, itemId);
        try {
            ApiClientResponse response = this.client.get(uri, this.getRequestHeaders(token));
            if (response.getResponseCode() >= 200 && response.getResponseCode() < 300) {
                return this.mapper.readValue(response.getResponseBody(), AlexaListItem.class);
            }
            throw new ServiceException("Got a non-successful response for list item query");
        }
        catch (IOException e) {
            throw new ServiceException("Encountered an IOException while attempting to retrieve list item", e);
        }
    }

    @Override
    public AlexaListItem createListItem(String listId, CreateListItemRequest request, String token) throws ServiceException {
        String uri = API_ENDPOINT + String.format("/v2/householdlists/%s/items", listId);
        try {
            ApiClientResponse response = this.client.post(uri, this.getRequestHeaders(token), this.mapper.writeValueAsString(request));
            if (response.getResponseCode() >= 200 && response.getResponseCode() < 300) {
                return this.mapper.readValue(response.getResponseBody(), AlexaListItem.class);
            }
            throw new ServiceException("Got a non-successful response for create list item request");
        }
        catch (IOException e) {
            throw new ServiceException("Encountered an IOException while attempting to create list item", e);
        }
    }

    @Override
    public AlexaListItem updateListItem(String listId, String itemId, UpdateListItemRequest request, String token) throws ServiceException {
        String uri = API_ENDPOINT + String.format("/v2/householdlists/%s/items/%s", listId, itemId);
        try {
            ApiClientResponse response = this.client.put(uri, this.getRequestHeaders(token), this.mapper.writeValueAsString(request));
            if (response.getResponseCode() >= 200 && response.getResponseCode() < 300) {
                return this.mapper.readValue(response.getResponseBody(), AlexaListItem.class);
            }
            throw new ServiceException("Got a non-successful response for update list item request");
        }
        catch (IOException e) {
            throw new ServiceException("Encountered an IOException while attempting to update list item", e);
        }
    }

    @Override
    public void deleteListItem(String listId, String itemId, String token) throws ServiceException {
        String uri = API_ENDPOINT + String.format("/v2/householdlists/%s/items/%s", listId, itemId);
        try {
            ApiClientResponse response = this.client.delete(uri, this.getRequestHeaders(token));
            if (response.getResponseCode() < 200 || response.getResponseCode() >= 300) {
                throw new ServiceException("Got a non-successful response for delete list item request");
            }
        }
        catch (IOException e) {
            throw new ServiceException("Encountered an IOException while attempting to delete list item", e);
        }
    }

    private Map<String, String> getRequestHeaders(String token) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + token);
        headers.put("Content-Type", "application/json");
        return headers;
    }
}

