/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.services;

import com.amazon.speech.speechlet.services.DirectiveEnvelopeHeader;
import com.amazon.speech.speechlet.services.SpeakDirective;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;

public class DirectiveEnvelope {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private DirectiveEnvelopeHeader header = null;
    private SpeakDirective directive = null;

    public DirectiveEnvelope() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private DirectiveEnvelope(Builder builder) {
        this.header = builder.header;
        this.directive = builder.directive;
    }

    public DirectiveEnvelopeHeader getHeader() {
        return this.header;
    }

    public SpeakDirective getDirective() {
        return this.directive;
    }

    public void toJson(OutputStream out) throws IOException {
        OBJECT_MAPPER.writeValue(out, (Object)this);
    }

    public byte[] toJsonBytes() throws IOException {
        return OBJECT_MAPPER.writeValueAsBytes(this);
    }

    public String toJsonString() throws IOException {
        return OBJECT_MAPPER.writeValueAsString(this);
    }

    static {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static final class Builder {
        private DirectiveEnvelopeHeader header;
        private SpeakDirective directive;

        public Builder withHeader(DirectiveEnvelopeHeader header) {
            this.header = header;
            return this;
        }

        public Builder withDirective(SpeakDirective directive) {
            this.directive = directive;
            return this;
        }

        public DirectiveEnvelope build() {
            return new DirectiveEnvelope(this);
        }
    }
}

