/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.services;

import com.amazon.speech.speechlet.services.ApiClientResponse;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

class ApiClient {
    ApiClient() {
    }

    public ApiClientResponse post(String uri, Map<String, String> headers, String body) throws IOException {
        return this.dispatch(uri, headers, body, "POST");
    }

    public ApiClientResponse put(String uri, Map<String, String> headers, String body) throws IOException {
        return this.dispatch(uri, headers, body, "PUT");
    }

    public ApiClientResponse get(String uri, Map<String, String> headers) throws IOException {
        return this.dispatch(uri, headers, null, "GET");
    }

    public ApiClientResponse delete(String uri, Map<String, String> headers) throws IOException {
        return this.dispatch(uri, headers, null, "DELETE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiClientResponse dispatch(String uri, Map<String, String> headers, String body, String method) throws IOException {
        HttpURLConnection connection = this.getHttpConnection(uri);
        try {
            ApiClientResponse apiClientResponse;
            this.writeHeaders(connection, headers, method);
            if (body != null) {
                this.writeRequestBody(connection, body);
            }
            ApiClientResponse apiClientResponse2 = apiClientResponse = this.readResponseBody(connection);
            return apiClientResponse2;
        }
        finally {
            connection.disconnect();
        }
    }

    private HttpURLConnection getHttpConnection(String uri) throws IOException {
        URL url = new URL(uri);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        return connection;
    }

    private void writeHeaders(HttpURLConnection connection, Map<String, String> headers, String method) throws IOException {
        connection.setRequestMethod(method);
        connection.setDoOutput(true);
        for (Map.Entry<String, String> header : headers.entrySet()) {
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
    }

    private void writeRequestBody(HttpURLConnection connection, String body) throws IOException {
        try (DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());){
            dataOutputStream.write(body.getBytes("UTF-8"));
        }
    }

    private ApiClientResponse readResponseBody(HttpURLConnection connection) throws IOException {
        StringBuffer responseSB = new StringBuffer();
        try (BufferedReader dataInputStream = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));){
            String line;
            while ((line = dataInputStream.readLine()) != null) {
                responseSB.append(line);
            }
        }
        return new ApiClientResponse(connection.getResponseCode(), responseSB.toString());
    }
}

