/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.lambda;

import com.amazon.speech.speechlet.Speechlet;
import com.amazon.speech.speechlet.SpeechletException;
import com.amazon.speech.speechlet.SpeechletRequestHandler;
import com.amazon.speech.speechlet.SpeechletRequestHandlerException;
import com.amazon.speech.speechlet.SpeechletToSpeechletV2Adapter;
import com.amazon.speech.speechlet.SpeechletV2;
import com.amazon.speech.speechlet.lambda.LambdaSpeechletRequestHandler;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public abstract class SpeechletRequestStreamHandler
implements RequestStreamHandler {
    private final SpeechletV2 speechlet;
    private final SpeechletRequestHandler speechletRequestHandler;

    public SpeechletRequestStreamHandler(SpeechletV2 speechlet, Set<String> supportedApplicationIds) {
        this.speechlet = speechlet;
        this.speechletRequestHandler = new LambdaSpeechletRequestHandler(supportedApplicationIds);
    }

    public SpeechletRequestStreamHandler(Speechlet speechlet, Set<String> supportedApplicationIds) {
        this(new SpeechletToSpeechletV2Adapter(speechlet), supportedApplicationIds);
    }

    @Override
    public final void handleRequest(InputStream input, OutputStream output, Context context) throws IOException {
        byte[] outputBytes;
        byte[] serializedSpeechletRequest = IOUtils.toByteArray(input);
        try {
            outputBytes = this.speechletRequestHandler.handleSpeechletCall(this.speechlet, serializedSpeechletRequest);
        }
        catch (SpeechletException | SpeechletRequestHandlerException ex) {
            throw new RuntimeException(ex);
        }
        output.write(outputBytes);
    }
}

