/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.interfaces.audioplayer;

import com.amazon.speech.speechlet.interfaces.audioplayer.PlayerActivity;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.Validate;

public class CurrentPlaybackState {
    private final Long offsetInMilliseconds;
    private final PlayerActivity playerActivity;
    private final String token;

    public static Builder builder() {
        return new Builder();
    }

    private CurrentPlaybackState(Builder builder) {
        this.offsetInMilliseconds = builder.offsetInMilliseconds;
        this.token = builder.token;
        this.playerActivity = builder.playerActivity;
    }

    private CurrentPlaybackState(@JsonProperty(value="offsetInMilliseconds") Long offsetInMilliseconds, @JsonProperty(value="token") String token, @JsonProperty(value="playerActivity") PlayerActivity playerActivity) {
        this.offsetInMilliseconds = offsetInMilliseconds;
        this.token = token;
        this.playerActivity = playerActivity;
    }

    public Long getOffsetInMilliseconds() {
        return this.offsetInMilliseconds;
    }

    public PlayerActivity getPlayerActivity() {
        return this.playerActivity;
    }

    public String getToken() {
        return this.token;
    }

    public static final class Builder {
        private Long offsetInMilliseconds;
        private PlayerActivity playerActivity;
        private String token;

        private Builder() {
        }

        public Builder withOffsetInMilliseconds(long offsetInMilliseconds) {
            this.offsetInMilliseconds = offsetInMilliseconds;
            return this;
        }

        public Builder withPlayerActivity(PlayerActivity playerActivity) {
            this.playerActivity = playerActivity;
            return this;
        }

        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        public CurrentPlaybackState build() {
            Validate.notNull(this.playerActivity, "PlayerActivity must be defined", new Object[0]);
            return new CurrentPlaybackState(this);
        }
    }
}

