/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet;

import com.amazon.speech.json.SpeechletRequestEnvelope;
import com.amazon.speech.json.SpeechletResponseEnvelope;
import com.amazon.speech.speechlet.CoreSpeechletRequest;
import com.amazon.speech.speechlet.IntentRequest;
import com.amazon.speech.speechlet.LaunchRequest;
import com.amazon.speech.speechlet.Session;
import com.amazon.speech.speechlet.SessionEndedRequest;
import com.amazon.speech.speechlet.SessionStartedRequest;
import com.amazon.speech.speechlet.Speechlet;
import com.amazon.speech.speechlet.SpeechletException;
import com.amazon.speech.speechlet.SpeechletRequest;
import com.amazon.speech.speechlet.SpeechletRequestHandlerException;
import com.amazon.speech.speechlet.SpeechletResponse;
import com.amazon.speech.speechlet.SpeechletToSpeechletV2Adapter;
import com.amazon.speech.speechlet.SpeechletV2;
import com.amazon.speech.speechlet.interfaces.audioplayer.AudioPlayer;
import com.amazon.speech.speechlet.interfaces.audioplayer.request.AudioPlayerRequest;
import com.amazon.speech.speechlet.interfaces.audioplayer.request.PlaybackFailedRequest;
import com.amazon.speech.speechlet.interfaces.audioplayer.request.PlaybackFinishedRequest;
import com.amazon.speech.speechlet.interfaces.audioplayer.request.PlaybackNearlyFinishedRequest;
import com.amazon.speech.speechlet.interfaces.audioplayer.request.PlaybackStartedRequest;
import com.amazon.speech.speechlet.interfaces.audioplayer.request.PlaybackStoppedRequest;
import com.amazon.speech.speechlet.interfaces.core.AccountLinkedRequest;
import com.amazon.speech.speechlet.interfaces.core.AlexaSkillEventRequest;
import com.amazon.speech.speechlet.interfaces.core.PermissionAcceptedRequest;
import com.amazon.speech.speechlet.interfaces.core.PermissionChangedRequest;
import com.amazon.speech.speechlet.interfaces.core.SkillDisabledEventRequest;
import com.amazon.speech.speechlet.interfaces.core.SkillEnabledEventRequest;
import com.amazon.speech.speechlet.interfaces.core.SkillEventListener;
import com.amazon.speech.speechlet.interfaces.display.Display;
import com.amazon.speech.speechlet.interfaces.display.request.DisplayRequest;
import com.amazon.speech.speechlet.interfaces.display.request.ElementSelectedRequest;
import com.amazon.speech.speechlet.interfaces.playbackcontroller.PlaybackController;
import com.amazon.speech.speechlet.interfaces.playbackcontroller.request.NextCommandIssuedRequest;
import com.amazon.speech.speechlet.interfaces.playbackcontroller.request.PauseCommandIssuedRequest;
import com.amazon.speech.speechlet.interfaces.playbackcontroller.request.PlayCommandIssuedRequest;
import com.amazon.speech.speechlet.interfaces.playbackcontroller.request.PlaybackControllerRequest;
import com.amazon.speech.speechlet.interfaces.playbackcontroller.request.PreviousCommandIssuedRequest;
import com.amazon.speech.speechlet.interfaces.system.System;
import com.amazon.speech.speechlet.interfaces.system.request.ExceptionEncounteredRequest;
import com.amazon.speech.speechlet.interfaces.system.request.SystemRequest;
import com.amazon.speech.speechlet.services.householdlist.AlexaHouseholdListEventRequest;
import com.amazon.speech.speechlet.services.householdlist.HouseholdListEventListener;
import com.amazon.speech.speechlet.services.householdlist.HouseholdListEventListenerV2;
import com.amazon.speech.speechlet.services.householdlist.HouseholdListEventListenerV2Adapter;
import com.amazon.speech.speechlet.services.householdlist.ListCreatedRequest;
import com.amazon.speech.speechlet.services.householdlist.ListDeletedRequest;
import com.amazon.speech.speechlet.services.householdlist.ListItemsCreatedRequest;
import com.amazon.speech.speechlet.services.householdlist.ListItemsDeletedRequest;
import com.amazon.speech.speechlet.services.householdlist.ListItemsUpdatedRequest;
import com.amazon.speech.speechlet.services.householdlist.ListUpdatedRequest;
import com.amazon.speech.speechlet.util.UserAgentUtils;
import java.io.IOException;
import java.util.Locale;

public class SpeechletRequestDispatcher {
    private final SpeechletV2 speechlet;
    private static final String USER_AGENT = UserAgentUtils.getUserAgent();

    public SpeechletRequestDispatcher(SpeechletV2 speechlet) {
        this.speechlet = speechlet;
    }

    public SpeechletRequestDispatcher(Speechlet speechlet) {
        this(new SpeechletToSpeechletV2Adapter(speechlet));
    }

    public SpeechletResponseEnvelope dispatchSpeechletCall(SpeechletRequestEnvelope<?> requestEnvelope, Session session) throws IOException, SpeechletRequestHandlerException, SpeechletException {
        Object speechletRequest = requestEnvelope.getRequest();
        SpeechletResponseEnvelope responseEnvelope = new SpeechletResponseEnvelope();
        responseEnvelope.setVersion("1.0");
        responseEnvelope.setUserAgent(USER_AGENT);
        if (session != null && session.isNew()) {
            String requestId = speechletRequest != null ? ((SpeechletRequest)speechletRequest).getRequestId() : null;
            Locale locale = speechletRequest != null ? ((SpeechletRequest)speechletRequest).getLocale() : null;
            SessionStartedRequest sessionStartedRequest = ((SessionStartedRequest.Builder)((SessionStartedRequest.Builder)SessionStartedRequest.builder().withRequestId(requestId)).withLocale(locale)).build();
            SpeechletRequestEnvelope<SessionStartedRequest> sessionStartedRequestEnvelope = SpeechletRequestEnvelope.builder().withContext(requestEnvelope.getContext()).withRequest(sessionStartedRequest).withSession(session).withVersion(requestEnvelope.getVersion()).build();
            try {
                this.speechlet.onSessionStarted(sessionStartedRequestEnvelope);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof SpeechletException) {
                    throw (SpeechletException)e.getCause();
                }
                throw e;
            }
        }
        SpeechletV2 speechletWithInterfaces = this.speechlet instanceof SpeechletToSpeechletV2Adapter ? ((SpeechletToSpeechletV2Adapter)this.speechlet).getSpeechlet() : this.speechlet;
        boolean saveSessionAttributes = false;
        SpeechletResponse speechletResponse = null;
        if (speechletRequest instanceof AlexaSkillEventRequest) {
            SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope;
            if (speechletRequest instanceof SkillEnabledEventRequest) {
                if (speechletWithInterfaces instanceof SkillEventListener) {
                    typeSpecificRequestEnvelope = requestEnvelope;
                    ((SkillEventListener)((Object)speechletWithInterfaces)).onSkillEnabled(typeSpecificRequestEnvelope);
                }
            } else if (speechletRequest instanceof SkillDisabledEventRequest) {
                if (speechletWithInterfaces instanceof SkillEventListener) {
                    typeSpecificRequestEnvelope = requestEnvelope;
                    ((SkillEventListener)((Object)speechletWithInterfaces)).onSkillDisabled(typeSpecificRequestEnvelope);
                }
            } else if (speechletRequest instanceof PermissionAcceptedRequest) {
                typeSpecificRequestEnvelope = requestEnvelope;
                ((SkillEventListener)((Object)speechletWithInterfaces)).onPermissionAccepted(typeSpecificRequestEnvelope);
            } else if (speechletRequest instanceof PermissionChangedRequest) {
                typeSpecificRequestEnvelope = requestEnvelope;
                ((SkillEventListener)((Object)speechletWithInterfaces)).onPermissionChanged(typeSpecificRequestEnvelope);
            } else if (speechletRequest instanceof AccountLinkedRequest) {
                typeSpecificRequestEnvelope = requestEnvelope;
                ((SkillEventListener)((Object)speechletWithInterfaces)).onAccountLinked(typeSpecificRequestEnvelope);
            }
        } else if (speechletRequest instanceof AlexaHouseholdListEventRequest) {
            HouseholdListEventListenerV2 listener;
            HouseholdListEventListenerV2 householdListEventListenerV2 = listener = speechletWithInterfaces instanceof HouseholdListEventListener ? new HouseholdListEventListenerV2Adapter((HouseholdListEventListener)((Object)speechletWithInterfaces)) : (HouseholdListEventListenerV2)((Object)speechletWithInterfaces);
            if (speechletRequest instanceof ListItemsCreatedRequest) {
                SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope = requestEnvelope;
                listener.onListItemsCreated(typeSpecificRequestEnvelope);
            } else if (speechletRequest instanceof ListItemsUpdatedRequest) {
                SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope = requestEnvelope;
                listener.onListItemsUpdated(typeSpecificRequestEnvelope);
            } else if (speechletRequest instanceof ListItemsDeletedRequest) {
                SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope = requestEnvelope;
                listener.onListItemsDeleted(typeSpecificRequestEnvelope);
            } else if (speechletRequest instanceof ListCreatedRequest) {
                SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope = requestEnvelope;
                listener.onListCreated(typeSpecificRequestEnvelope);
            } else if (speechletRequest instanceof ListUpdatedRequest) {
                SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope = requestEnvelope;
                listener.onListUpdated(typeSpecificRequestEnvelope);
            } else if (speechletRequest instanceof ListDeletedRequest) {
                SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope = requestEnvelope;
                listener.onListDeleted(typeSpecificRequestEnvelope);
            }
        } else if (speechletRequest instanceof AudioPlayerRequest) {
            if (speechletWithInterfaces instanceof AudioPlayer) {
                AudioPlayer audioPlayerSpeechlet = (AudioPlayer)((Object)speechletWithInterfaces);
                if (speechletRequest instanceof PlaybackFailedRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope = requestEnvelope;
                    speechletResponse = audioPlayerSpeechlet.onPlaybackFailed(typeSpecificRequestEnvelope);
                } else if (speechletRequest instanceof PlaybackFinishedRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope = requestEnvelope;
                    speechletResponse = audioPlayerSpeechlet.onPlaybackFinished(typeSpecificRequestEnvelope);
                } else if (speechletRequest instanceof PlaybackNearlyFinishedRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope = requestEnvelope;
                    speechletResponse = audioPlayerSpeechlet.onPlaybackNearlyFinished(typeSpecificRequestEnvelope);
                } else if (speechletRequest instanceof PlaybackStartedRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope = requestEnvelope;
                    speechletResponse = audioPlayerSpeechlet.onPlaybackStarted(typeSpecificRequestEnvelope);
                } else if (speechletRequest instanceof PlaybackStoppedRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope = requestEnvelope;
                    speechletResponse = audioPlayerSpeechlet.onPlaybackStopped(typeSpecificRequestEnvelope);
                }
            }
        } else if (speechletRequest instanceof PlaybackControllerRequest) {
            if (speechletWithInterfaces instanceof PlaybackController) {
                PlaybackController playbackControllerSpeechlet = (PlaybackController)((Object)speechletWithInterfaces);
                if (speechletRequest instanceof NextCommandIssuedRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope = requestEnvelope;
                    speechletResponse = playbackControllerSpeechlet.onNextCommandIssued(typeSpecificRequestEnvelope);
                } else if (speechletRequest instanceof PreviousCommandIssuedRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope = requestEnvelope;
                    speechletResponse = playbackControllerSpeechlet.onPreviousCommandIssued(typeSpecificRequestEnvelope);
                } else if (speechletRequest instanceof PauseCommandIssuedRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope = requestEnvelope;
                    speechletResponse = playbackControllerSpeechlet.onPauseCommandIssued(typeSpecificRequestEnvelope);
                } else if (speechletRequest instanceof PlayCommandIssuedRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope = requestEnvelope;
                    speechletResponse = playbackControllerSpeechlet.onPlayCommandIssued(typeSpecificRequestEnvelope);
                }
            }
        } else if (speechletRequest instanceof SystemRequest) {
            if (speechletWithInterfaces instanceof System) {
                System systemSpeechlet = (System)((Object)speechletWithInterfaces);
                if (speechletRequest instanceof ExceptionEncounteredRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope = requestEnvelope;
                    systemSpeechlet.onExceptionEncountered(typeSpecificRequestEnvelope);
                }
            }
        } else if (speechletRequest instanceof DisplayRequest) {
            if (speechletWithInterfaces instanceof Display) {
                Display displaySpeechlet = (Display)((Object)speechletWithInterfaces);
                if (speechletRequest instanceof ElementSelectedRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope = requestEnvelope;
                    speechletResponse = displaySpeechlet.onElementSelected(typeSpecificRequestEnvelope);
                    saveSessionAttributes = this.shouldSaveSessionAttributes(speechletResponse);
                }
            }
        } else if (speechletRequest instanceof CoreSpeechletRequest) {
            try {
                SpeechletRequestEnvelope<SkillEnabledEventRequest> parameterizedRequestEnvelope;
                if (speechletRequest instanceof SessionEndedRequest) {
                    parameterizedRequestEnvelope = requestEnvelope;
                    this.speechlet.onSessionEnded(parameterizedRequestEnvelope);
                }
                if (speechletRequest instanceof IntentRequest) {
                    parameterizedRequestEnvelope = requestEnvelope;
                    speechletResponse = this.speechlet.onIntent(parameterizedRequestEnvelope);
                } else if (speechletRequest instanceof LaunchRequest) {
                    parameterizedRequestEnvelope = requestEnvelope;
                    speechletResponse = this.speechlet.onLaunch(parameterizedRequestEnvelope);
                }
                saveSessionAttributes = this.shouldSaveSessionAttributes(speechletResponse);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof SpeechletException) {
                    throw (SpeechletException)e.getCause();
                }
                throw e;
            }
        } else {
            String requestType = speechletRequest != null ? speechletRequest.getClass().getName() : null;
            String message = String.format("Unsupported request type %s. Consider updating your SDK version. Request envelope version %s, SDK version %s", requestType, requestEnvelope.getVersion(), "1.0");
            throw new SpeechletRequestHandlerException(message);
        }
        responseEnvelope.setResponse(speechletResponse);
        if (saveSessionAttributes && session != null) {
            responseEnvelope.setSessionAttributes(session.getAttributes());
        }
        return responseEnvelope;
    }

    private boolean shouldSaveSessionAttributes(SpeechletResponse speechletResponse) {
        if (speechletResponse != null && speechletResponse.getNullableShouldEndSession() != null) {
            return speechletResponse.getNullableShouldEndSession() == false;
        }
        return true;
    }
}

