/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet;

import com.amazon.speech.speechlet.CoreSpeechletRequest;
import com.amazon.speech.speechlet.SpeechletRequest;
import com.amazon.speech.speechlet.interfaces.system.Error;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.Validate;

@JsonTypeName(value="SessionEndedRequest")
public final class SessionEndedRequest
extends CoreSpeechletRequest {
    private final Reason reason;
    private final Error error;

    public static Builder builder() {
        return new Builder();
    }

    private SessionEndedRequest(Builder builder) {
        super(builder);
        this.reason = builder.reason;
        this.error = builder.error;
    }

    private SessionEndedRequest(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="timestamp") Date timestamp, @JsonProperty(value="locale") Locale locale, @JsonProperty(value="reason") Reason reason, @JsonProperty(value="error") Error error) {
        super(requestId, timestamp, locale);
        this.reason = reason;
        this.error = error;
    }

    public Reason getReason() {
        return this.reason;
    }

    public Error getError() {
        return this.error;
    }

    public static final class Builder
    extends SpeechletRequest.SpeechletRequestBuilder<Builder, SessionEndedRequest> {
        private Reason reason;
        private Error error;

        private Builder() {
        }

        public Builder withReason(Reason reason) {
            this.reason = reason;
            return this;
        }

        public Builder withError(Error error) {
            this.error = error;
            return this;
        }

        @Override
        public SessionEndedRequest build() {
            Validate.notBlank(this.getRequestId(), "RequestId must be defined", new Object[0]);
            return new SessionEndedRequest(this);
        }
    }

    public static enum Reason {
        USER_INITIATED,
        ERROR,
        EXCEEDED_MAX_REPROMPTS;

    }
}

