/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.json;

import com.amazon.speech.json.SerializedInterface;
import com.amazon.speech.speechlet.Interface;
import com.amazon.speech.speechlet.SupportedInterfaces;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;

class SupportedInterfacesDeserializer
extends StdDeserializer<SupportedInterfaces> {
    SupportedInterfacesDeserializer() {
        super(SupportedInterfaces.class);
    }

    @Override
    public SupportedInterfaces deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        ObjectMapper underlyingMapper = (ObjectMapper)parser.getCodec();
        JsonNode messageNode = (JsonNode)parser.readValueAsTree();
        SupportedInterfaces.Builder supportedInterfacesBuilder = SupportedInterfaces.builder();
        for (SerializedInterface interfaceName : SerializedInterface.values()) {
            if (!messageNode.has(interfaceName.name())) continue;
            Interface supportedInterface = (Interface)underlyingMapper.convertValue((Object)messageNode.get(interfaceName.name()), interfaceName.getInterfaceClass());
            supportedInterfacesBuilder.addSupportedInterface(supportedInterface);
        }
        return supportedInterfacesBuilder.build();
    }
}

