/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.json;

import com.amazon.speech.json.SpeechletRequestModule;
import com.amazon.speech.speechlet.Context;
import com.amazon.speech.speechlet.Session;
import com.amazon.speech.speechlet.SpeechletRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;

public class SpeechletRequestEnvelope<T extends SpeechletRequest> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final String version;
    private final Session session;
    private final Context context;
    private final T request;

    public static <E extends SpeechletRequest> Builder<E> builder() {
        return new Builder();
    }

    private SpeechletRequestEnvelope(Builder<T> builder) {
        this.version = ((Builder)builder).version;
        this.session = ((Builder)builder).session;
        this.context = ((Builder)builder).context;
        this.request = ((Builder)builder).request;
    }

    private SpeechletRequestEnvelope(@JsonProperty(value="version") String version, @JsonProperty(value="session") Session session, @JsonProperty(value="context") Context context, @JsonProperty(value="request") T request) {
        this.version = version;
        this.session = session;
        this.context = context;
        this.request = request;
    }

    public String getVersion() {
        return this.version;
    }

    public Session getSession() {
        return this.session;
    }

    public Context getContext() {
        return this.context;
    }

    public T getRequest() {
        return this.request;
    }

    public static SpeechletRequestEnvelope<?> fromJson(InputStream in) throws IOException {
        return OBJECT_MAPPER.readValue(in, SpeechletRequestEnvelope.class);
    }

    public static SpeechletRequestEnvelope<?> fromJson(byte[] json) throws IOException {
        return OBJECT_MAPPER.readValue(json, SpeechletRequestEnvelope.class);
    }

    public static SpeechletRequestEnvelope<?> fromJson(String json) throws IOException {
        return OBJECT_MAPPER.readValue(json, SpeechletRequestEnvelope.class);
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        OBJECT_MAPPER.registerModule(new SpeechletRequestModule());
    }

    public static final class Builder<T extends SpeechletRequest> {
        private String version = "1.0";
        private Session session;
        private Context context;
        private T request;

        private Builder() {
        }

        public Builder<T> withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder<T> withSession(Session session) {
            this.session = session;
            return this;
        }

        public Builder<T> withContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder<T> withRequest(T request) {
            this.request = request;
            return this;
        }

        public SpeechletRequestEnvelope<T> build() {
            return new SpeechletRequestEnvelope(this);
        }
    }
}

