@file:OptIn(ExperimentalJsExport::class)

import io.kform.validations.GreaterThan
import io.kform.validations.LessThan
import io.kform.validations.Max
import io.kform.validations.Min

/** [Minimum][Min] validation wrapper for use from JavaScript. */
@JsExport
@JsName("min")
public fun minJs(
    min: Double,
    code: String = Min.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<Double> = Min(min, code, severity.toValidationIssueSeverityKt()).cachedToJs()

/** [Maximum][Max] validation wrapper for use from JavaScript. */
@JsExport
@JsName("max")
public fun maxJs(
    max: Double,
    code: String = Max.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<Double> = Max(max, code, severity.toValidationIssueSeverityKt()).cachedToJs()

/** [Greater than][GreaterThan] validation wrapper for use from JavaScript. */
@JsExport
@JsName("greaterThan")
public fun greaterThanJs(
    greaterThan: Double,
    code: String = GreaterThan.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<Double> =
    GreaterThan(greaterThan, code, severity.toValidationIssueSeverityKt()).cachedToJs()

/** [Less than][LessThan] validation wrapper for use from JavaScript. */
@JsExport
@JsName("lessThan")
public fun lessThanJs(
    lessThan: Double,
    code: String = LessThan.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<Double> =
    LessThan(lessThan, code, severity.toValidationIssueSeverityKt()).cachedToJs()
