/** Converts an iterable into an array while caching the conversion. */
internal fun <T> Iterable<T>.cachedToJs(): Array<T> =
    getOrSetFromCache(this) { this.toList().toTypedArray() }

/** Converts an iterable into an array while caching the conversion and mapping each element. */
internal fun <T, TResult> Iterable<T>.cachedToJs(
    valueMapper: (value: T) -> TResult
): Array<TResult> = getOrSetFromCache(this) { this.map(valueMapper).toTypedArray() }
