@file:OptIn(ExperimentalJsExport::class)

import io.github.oshai.kotlinlogging.KotlinLoggingConfiguration
import io.github.oshai.kotlinlogging.Level

/** Log level for use from JavaScript (`"trace" | "debug" | "info" | "warn" | "error" | "off"`). */
public typealias LogLevelJs = String

/**
 * Sets the [level] of logging to one of: `"trace"`, `"debug"`, `"info"`, `"warn"`, `"error"`,
 * `"off"`.
 *
 * The default logging level is `"info"`.
 */
@JsExport
public fun setLogLevel(level: LogLevelJs) {
    KotlinLoggingConfiguration.LOG_LEVEL = Level.valueOf(level.uppercase())
}
