import io.kform.validations.ExclusiveMax
import io.kform.validations.ExclusiveMin
import io.kform.validations.Max
import io.kform.validations.Min

/** [Minimum][Min] validation wrapper for use from JavaScript. */
@JsExport
@JsName("min")
public fun <T : Comparable<T>> minJs(
    min: T,
    code: String = Min.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<T> = Min(min, code, severity.toValidationIssueSeverityKt()).cachedToJs()

/** [Maximum][Max] validation wrapper for use from JavaScript. */
@JsExport
@JsName("max")
public fun <T : Comparable<T>> maxJs(
    max: T,
    code: String = Max.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<T> = Max(max, code, severity.toValidationIssueSeverityKt()).cachedToJs()

/** [Exclusive minimum][ExclusiveMin] validation wrapper for use from JavaScript. */
@JsExport
@JsName("exclusiveMin")
public fun <T : Comparable<T>> exclusiveMinJs(
    exclusiveMin: T,
    code: String = ExclusiveMin.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<T> =
    ExclusiveMin(exclusiveMin, code, severity.toValidationIssueSeverityKt()).cachedToJs()

/** [Exclusive maximum][ExclusiveMax] validation wrapper for use from JavaScript. */
@JsExport
@JsName("exclusiveMax")
public fun <T : Comparable<T>> exclusiveMaxJs(
    exclusiveMax: T,
    code: String = ExclusiveMax.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<T> =
    ExclusiveMax(exclusiveMax, code, severity.toValidationIssueSeverityKt()).cachedToJs()
