import io.kform.datatypes.File
import io.kform.validations.Accepts

/** [Accepts] validation wrapper for use from JavaScript. */
@JsExport
@JsName("accepts")
public fun acceptsJs(
    allowedFileTypes: Array<String>,
    code: String = Accepts.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<File> =
    Accepts(allowedFileTypes.asIterable(), code, severity.toValidationIssueSeverityKt())
        .cachedToJs()
