import io.kform.datatypes.File
import io.kform.datatypes.emptyPlaceholderFile
import io.kform.schemas.FileSchema

/** [File schema][FileSchema] wrapper for use from JavaScript. */
@JsName("fileSchema")
@JsExport
public fun fileSchemaJs(options: SchemaOptionsJs<File>? = null): SchemaJs<File> =
    FileSchema(
            options?.validations?.map { it.validationKt } ?: emptyList(),
            options?.initialValue ?: emptyPlaceholderFile(),
        )
        .cachedToJs()
