import io.kform.Path

/** [Path] wrapper for use from JavaScript. */
@JsExport
@JsName("Path")
public open class PathJs(path: Any = emptyArray<PathFragmentJs>()) {
    internal open val pathKt: Path =
        when (path) {
            is Path -> path
            is PathJs -> path.pathKt
            is Array<*> -> Path(path.map { (it as PathFragmentJs).fragmentKt })
            else -> Path(path.toString())
        }

    public open val fragments: Array<Any>
        get() = pathKt.fragments.cachedToJs { it.toJs() }

    public open fun fragment(index: Int): Any = pathKt[index].toJs()

    public open fun parent(): PathJs = PathJs(pathKt.parent())

    public open fun append(): PathJs =
        PathJs(
            pathKt.append(
                *functionArguments<Any>().map { (it as PathFragmentJs).fragmentKt }.toTypedArray()
            )
        )

    public fun join(): PathJs =
        PathJs(
            pathKt.join(
                *functionArguments<Any>()
                    .map { if (it is PathJs) it.pathKt else Path(it.toString()) }
                    .toTypedArray()
            )
        )

    public open fun resolve(): PathJs =
        PathJs(
            pathKt.resolve(
                *functionArguments<Any>()
                    .map { if (it is PathJs) it.pathKt else Path(it.toString()) }
                    .toTypedArray()
            )
        )

    public override fun equals(other: Any?): Boolean =
        when {
            this === other -> true
            other !is PathJs -> false
            else -> pathKt == other.pathKt
        }

    public override fun hashCode(): Int = pathKt.hashCode()

    public override fun toString(): String = pathKt.toString()

    public companion object {
        /** [Current path][Path.CURRENT] wrapper for use from JavaScript. */
        @JsStatic public val CURRENT: PathJs = PathJs(Path.CURRENT)

        /** [Current deep path][Path.CURRENT_DEEP] wrapper for use from JavaScript. */
        @JsStatic public val CURRENT_DEEP: PathJs = PathJs(Path.CURRENT_DEEP)

        /** [Parent path][Path.PARENT] wrapper for use from JavaScript. */
        @JsStatic public val PARENT: PathJs = PathJs(Path.PARENT)

        /** [Children path][Path.CHILDREN] wrapper for use from JavaScript. */
        @JsStatic public val CHILDREN: PathJs = PathJs(Path.CHILDREN)

        /** [Descendants path][Path.DESCENDANTS] wrapper for use from JavaScript. */
        @JsStatic public val DESCENDANTS: PathJs = PathJs(Path.DESCENDANTS)
    }
}

/**
 * Function which converts a [Path] into a wrapped [PathJs] object to be used from JavaScript, while
 * caching the conversion in the process.
 */
internal fun Path.cachedToJs(): PathJs = getOrSetFromCache(this) { PathJs(this) }

/** Function that converts a wrapped [PathJs] or a string into a [Path]. */
internal fun Any.toPathKt(): Path =
    when (this) {
        is PathJs -> pathKt
        is String -> Path(this)
        else -> error("Invalid path.")
    }
