import io.kform.Info
import io.kform.SchemaInfo
import io.kform.ValueInfo

/** [Schema info][SchemaInfo] wrapper for use from JavaScript. */
@JsExport
@JsName("SchemaInfo")
public class SchemaInfoJs<T> internal constructor(private val infoKt: SchemaInfo<T>) {
    public val schema: SchemaJs<T>
        get() = infoKt.schema.cachedToJs()

    public val path: AbsolutePathJs
        get() = infoKt.path.cachedToJs()

    public val queriedPath: AbsolutePathJs
        get() = infoKt.queriedPath.cachedToJs()

    public override fun equals(other: Any?): Boolean =
        when {
            this === other -> true
            other !is SchemaInfoJs<*> -> false
            else -> infoKt == other.infoKt
        }

    public override fun hashCode(): Int = infoKt.hashCode()

    public override fun toString(): String = infoKt.toString()
}

/** [Value info][ValueInfo] wrapper for use from JavaScript. */
@JsExport
@JsName("ValueInfo")
public class ValueInfoJs<T> internal constructor(private val infoKt: ValueInfo<T>) {
    public val value: T
        get() = infoKt.value

    public val schema: SchemaJs<T>
        get() = infoKt.schema.cachedToJs()

    public val path: AbsolutePathJs
        get() = infoKt.path.cachedToJs()

    public val schemaPath: AbsolutePathJs
        get() = infoKt.schemaPath.cachedToJs()

    public override fun equals(other: Any?): Boolean =
        when {
            this === other -> true
            other !is ValueInfoJs<*> -> false
            else -> infoKt == other.infoKt
        }

    public override fun hashCode(): Int = infoKt.hashCode()

    public override fun toString(): String = infoKt.toString()
}

/** [Info] wrapper for use from JavaScript. */
@JsExport
@JsName("Info")
public class InfoJs<T> internal constructor(private val infoKt: Info<T>) {
    public val value: T
        get() = infoKt.value

    public val schema: SchemaJs<T>
        get() = infoKt.schema.cachedToJs()

    public val path: AbsolutePathJs
        get() = infoKt.path.cachedToJs()

    public val schemaPath: AbsolutePathJs
        get() = infoKt.schemaPath.cachedToJs()

    public val dirty: Boolean
        get() = infoKt.dirty

    public val touched: Boolean
        get() = infoKt.touched

    public val issues: Array<ValidationIssueJs>
        get() = infoKt.issues.cachedToJs { it.cachedToJs() }

    public val validationStatus: ValidationStatusJs
        get() = infoKt.validationStatus.toJs()

    public val displayStatus: DisplayStatusJs
        get() = infoKt.displayStatus.toJs()

    public override fun equals(other: Any?): Boolean =
        when {
            this === other -> true
            other !is InfoJs<*> -> false
            else -> infoKt == other.infoKt
        }

    public override fun hashCode(): Int = infoKt.hashCode()

    public override fun toString(): String = infoKt.toString()
}

internal fun <T> SchemaInfo<T>.cachedToJs(): SchemaInfoJs<T> =
    getOrSetFromCache(this) { SchemaInfoJs(this) }

internal fun <T> ValueInfo<T>.cachedToJs(): ValueInfoJs<T> =
    getOrSetFromCache(this) { ValueInfoJs(this) }

internal fun <T> Info<T>.cachedToJs(): InfoJs<T> = getOrSetFromCache(this) { InfoJs(this) }
